package junkutil.excel;

import java.io.File;
import java.io.IOException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junkutil.common.StringUtil;
import junkutil.excel.CSV;

/**
 * CSVeXgB
 */
public class CSVTest extends TestCase {
	/**
	 * RXgN^
	 * @param name
	 */
	public CSVTest(String name) {
		super(name);
	}

	/**
	 * @return
	 */
	public static Test suite() {
		TestSuite test = new TestSuite("CSVTest");
		test.addTest(new TestSuite(CSVTest.class));
	
		return test;
	}

	/**
	 * @see junit.framework.TestCase#setUp()
	 */
	protected void setUp() throws Exception {
	}

	/**
	 * @see junit.framework.TestCase#tearDown()
	 */
	protected void tearDown() throws Exception {
	}

	/**
	 * @throws Exception
	 */
	public void testCSV2Strings() throws Exception {
		assertTrue(StringUtil.equals(CSV.csvToStrings("AAA,BBBB,CCCCC"), new String[]{"AAA","BBBB","CCCCC"}));
		assertTrue(StringUtil.equals(CSV.csvToStrings("AAA,,,BBBB,,,CCCCC"), new String[]{"AAA","","","BBBB","","","CCCCC"}));
		assertTrue(StringUtil.equals(CSV.csvToStrings("\"AA,,AImpl\",BBBB,\",\""), new String[]{"AA,,AImpl","BBBB",","}));
	}

	/**
	 * @throws Exception
	 */
	public void testStrings2CSV() throws Exception {
		String[] csvSource = {"abc", "de\"f", "g\"h\"i", "j\"\"k\"\"l"};
		assertTrue(CSV.stringsToCsv(csvSource, CSV.MOST_QUOTE).equals("\"abc\",\"de\"\"f\",\"g\"\"h\"\"i\",\"j\"\"\"\"k\"\"\"\"l\""));
		assertTrue(CSV.stringsToCsv(csvSource, CSV.ANY_QUOTE).equals("abc,\"de\"\"f\",\"g\"\"h\"\"i\",\"j\"\"\"\"k\"\"\"\"l\""));
		assertTrue(CSV.stringsToCsv(csvSource, CSV.NO_QUOTE).equals("abc,de\"\"f,g\"\"h\"\"i,j\"\"\"\"k\"\"\"\"l"));
	}

}
