/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.reflect;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.maachang.reflect.FastClassElement;
import org.maachang.reflect.FastReflectClass;
import org.maachang.reflect.FastReflectPrimitive;

abstract class FastReflectUtil {
    private static final Map<Class, Class> CONV_PRIMITIVE = FastReflectPrimitive.CONV_PRIMITIVE;
    private static final Set<Class> PRIMITIVE = FastReflectPrimitive.PRIMITIVE;
    private static final Object OBJECT = FastReflectPrimitive.OBJECT;
    private static final Object STRING = FastReflectPrimitive.STRING;
    private static final Set<Class> NUMBER_PRIMITIVE = FastReflectPrimitive.NUMBER_PRIMITIVE;
    private static final Map<Class, Integer> CONV_TABLE;

    static {
        HashMap<Class, Integer> m = new HashMap<Class, Integer>();
        m.put(Byte.class, 0);
        m.put(Character.class, 1);
        m.put(Short.class, 2);
        m.put(Integer.class, 3);
        m.put(Long.class, 4);
        m.put(Float.class, 5);
        m.put(Double.class, 6);
        CONV_TABLE = m;
    }

    private FastReflectUtil() {
    }

    public static final Class[] getParamsType(Object ... args) {
        int argsLen;
        if (args == null || (argsLen = args.length) <= 0) {
            return FastReflectPrimitive.NO_PARAM_CLASS;
        }
        Class[] c = new Class[argsLen];
        int i = 0;
        while (i < argsLen) {
            Object o = args[i];
            if (o != null) {
                c[i] = o.getClass();
            }
            ++i;
        }
        return c;
    }

    public static final Class[] getParamsTypeByClass(Class[] args) {
        int argsLen;
        if (args == null || (argsLen = args.length) <= 0) {
            return FastReflectPrimitive.NO_PARAM_CLASS;
        }
        int i = 0;
        while (i < argsLen) {
            Class pc;
            if (args[i] != null && (pc = CONV_PRIMITIVE.get(args[i])) != null) {
                args[i] = pc;
            }
            ++i;
        }
        return args;
    }

    public static final int parmasScore(boolean[] pms, Class[] src, Class[] dest, ClassLoader cl) throws ClassNotFoundException {
        int ret = 0;
        boolean one = true;
        int len = src.length;
        int i = 0;
        while (i < len) {
            block17: {
                block15: {
                    block14: {
                        Class o;
                        int wScore;
                        FastClassElement em;
                        Class s;
                        block21: {
                            Class d;
                            block20: {
                                block19: {
                                    block18: {
                                        block16: {
                                            s = src[i];
                                            d = dest[i];
                                            if (d == null) break block15;
                                            if (s != d) break block16;
                                            ret += 100;
                                            break block17;
                                        }
                                        if (s != OBJECT) break block18;
                                        ret += 60;
                                        break block17;
                                    }
                                    if (!NUMBER_PRIMITIVE.contains(s) || !NUMBER_PRIMITIVE.contains(d)) break block19;
                                    ret += 50;
                                    break block17;
                                }
                                if ((s != STRING || !PRIMITIVE.contains(d)) && (d != STRING || !PRIMITIVE.contains(s))) break block20;
                                ret += 40;
                                break block17;
                            }
                            em = FastReflectClass.getClass(d.getName());
                            one = false;
                            wScore = 100;
                            if (!s.isInterface()) break block21;
                            String sname = s.getName();
                            do {
                                int lenJ;
                                int befWScore = --wScore;
                                Object[] ifce = em.getInterfaseNames();
                                if (ifce != null && (lenJ = ifce.length) > 0) {
                                    if (Arrays.binarySearch(ifce, sname) != -1) {
                                        one = true;
                                        ret += wScore;
                                    } else if (lenJ == 1) {
                                        if ((wScore = FastReflectUtil.toInterface(wScore, sname, (String)ifce[0], cl)) != -1) {
                                            one = true;
                                            ret += wScore;
                                        }
                                    } else {
                                        int j = 0;
                                        while (j < lenJ) {
                                            if ((wScore = FastReflectUtil.toInterface(wScore, sname, (String)ifce[i], cl)) != -1) {
                                                one = true;
                                                ret += wScore;
                                                break;
                                            }
                                            ++j;
                                        }
                                    }
                                    if (one) break block14;
                                }
                                wScore = befWScore;
                                o = (em = FastReflectClass.getClass(em.getSuperClassName())).getClassObject();
                                if (o != OBJECT) continue;
                                return -1;
                            } while (o != s);
                            one = true;
                            ret += wScore;
                            break block14;
                            {
                            }
                        }
                        do {
                            --wScore;
                            o = (em = FastReflectClass.getClass(em.getSuperClassName())).getClassObject();
                            if (o != OBJECT) continue;
                            return -1;
                        } while (o != s);
                        one = true;
                        ret += wScore;
                    }
                    if (!one) {
                        return -1;
                    }
                    break block17;
                }
                if (pms[i]) {
                    return -1;
                }
            }
            ++i;
        }
        return ret;
    }

    private static final int toInterface(int wScore, String sname, String name, ClassLoader cl) throws ClassNotFoundException {
        FastClassElement em = FastReflectClass.getClass(cl, name);
        while (em != null) {
            --wScore;
            String superClassName = em.getSuperClassName();
            if (superClassName == sname) {
                return wScore;
            }
            em = FastReflectClass.getClass(cl, superClassName);
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final Object[] convertParams(Object[] args, Class[] types) {
        int len = args.length;
        if (len <= 0) {
            return FastReflectPrimitive.NO_PARAM;
        }
        Object[] ret = new Object[len];
        System.arraycopy(args, 0, ret, 0, len);
        int i = 0;
        while (i < len) {
            Class<?> d;
            Class s;
            if (ret[i] != null && (s = types[i]) != (d = ret[i].getClass())) {
                if (NUMBER_PRIMITIVE.contains(s) && NUMBER_PRIMITIVE.contains(d)) {
                    ret[i] = FastReflectUtil.convertNumberPrimitive(ret[i], CONV_TABLE.get(s), CONV_TABLE.get(d));
                } else if (s == STRING && PRIMITIVE.contains(d)) {
                    ret[i] = ret[i].toString();
                } else if (d == STRING && PRIMITIVE.contains(s)) {
                    if (s == Boolean.class) {
                        String str = ((String)args[i]).toLowerCase();
                        if (str.equals("true")) {
                            ret[i] = Boolean.TRUE;
                        } else {
                            if (!str.equals("false")) throw new ClassCastException("\u7b2c" + (i + 1) + "\u5f15\u6570\u306e\u30ad\u30e3\u30b9\u30c8\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                            ret[i] = Boolean.FALSE;
                        }
                    } else {
                        Integer o = CONV_TABLE.get(s);
                        if (o != null) {
                            ret[i] = FastReflectUtil.convertNumber(o, (String)ret[i]);
                        }
                    }
                }
            }
            ++i;
        }
        return ret;
    }

    private static final Object convertNumber(int type, String s) {
        if ((s = s.trim().toLowerCase()).endsWith("f") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
        }
        if (type == 5 || type == 6) {
            return FastReflectUtil.convertType(type, s);
        }
        int p = s.indexOf(".");
        if (p == -1) {
            if (s.startsWith("0x")) {
                int len = (s = s.substring(2)).length();
                if (len > 8) {
                    if (len > 16) {
                        throw new NumberFormatException("\u6570\u5024\u5909\u63db\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
                    }
                    long ret = 0L;
                    int i = 0;
                    while (i < len) {
                        char c = s.charAt(i);
                        if (c >= '1' && c <= '9') {
                            ret |= (long)(c - 48 << i);
                        } else if (c >= 'a' && c <= 'f') {
                            ret |= (long)(c - 97 + 10 << i);
                        }
                        ++i;
                    }
                    switch (type) {
                        case 0: {
                            return (byte)(ret & 0xFFL);
                        }
                        case 1: {
                            return Character.valueOf((char)(ret & 0xFFFFL));
                        }
                        case 2: {
                            return (short)(ret & 0xFFFFL);
                        }
                        case 3: {
                            return (int)(ret & 0xFFFFFFFFL);
                        }
                        case 4: {
                            return ret;
                        }
                    }
                    return null;
                }
                int ret = 0;
                int i = 0;
                while (i < len) {
                    char c = s.charAt(i);
                    if (c >= '1' && c <= '9') {
                        ret |= c - 48 << i;
                    } else if (c >= 'a' && c <= 'f') {
                        ret |= c - 97 + 10 << i;
                    }
                    ++i;
                }
                switch (type) {
                    case 0: {
                        return (byte)(ret & 0xFF);
                    }
                    case 1: {
                        return Character.valueOf((char)(ret & 0xFFFF));
                    }
                    case 2: {
                        return (short)(ret & 0xFFFF);
                    }
                    case 3: {
                        return ret;
                    }
                    case 4: {
                        return (long)ret;
                    }
                }
                return null;
            }
            return FastReflectUtil.convertType(type, s);
        }
        return FastReflectUtil.convertType(type, s.substring(0, p));
    }

    private static final Object convertType(int type, String s) {
        switch (type) {
            case 0: {
                return Byte.parseByte(s);
            }
            case 1: {
                return Character.valueOf(s.length() == 1 ? s.charAt(0) : (char)(Integer.parseInt(s) & 0xFFFF));
            }
            case 2: {
                return Short.parseShort(s);
            }
            case 3: {
                return Integer.parseInt(s);
            }
            case 4: {
                return Long.parseLong(s);
            }
            case 5: {
                return Float.valueOf(Float.parseFloat(s));
            }
            case 6: {
                return Double.parseDouble(s);
            }
        }
        return s;
    }

    private static final Object convertNumberPrimitive(Object o, int srcType, int destType) {
        switch (destType) {
            case 0: {
                byte by = (Byte)o;
                switch (srcType) {
                    case 0: {
                        return by;
                    }
                    case 1: {
                        return Character.valueOf((char)by);
                    }
                    case 2: {
                        return (short)by;
                    }
                    case 3: {
                        return (int)by;
                    }
                    case 4: {
                        return (long)by;
                    }
                    case 5: {
                        return Float.valueOf(by);
                    }
                    case 6: {
                        return (double)by;
                    }
                }
            }
            case 1: {
                char c = ((Character)o).charValue();
                switch (srcType) {
                    case 0: {
                        return (byte)c;
                    }
                    case 1: {
                        return Character.valueOf(c);
                    }
                    case 2: {
                        return (short)c;
                    }
                    case 3: {
                        return (int)c;
                    }
                    case 4: {
                        return (long)c;
                    }
                    case 5: {
                        return Float.valueOf(c);
                    }
                    case 6: {
                        return (double)c;
                    }
                }
            }
            case 2: {
                short s = (Short)o;
                switch (srcType) {
                    case 0: {
                        return (byte)s;
                    }
                    case 1: {
                        return Character.valueOf((char)s);
                    }
                    case 2: {
                        return s;
                    }
                    case 3: {
                        return (int)s;
                    }
                    case 4: {
                        return (long)s;
                    }
                    case 5: {
                        return Float.valueOf(s);
                    }
                    case 6: {
                        return (double)s;
                    }
                }
            }
            case 3: {
                int n = (Integer)o;
                switch (srcType) {
                    case 0: {
                        return (byte)n;
                    }
                    case 1: {
                        return Character.valueOf((char)n);
                    }
                    case 2: {
                        return (short)n;
                    }
                    case 3: {
                        return n;
                    }
                    case 4: {
                        return (long)n;
                    }
                    case 5: {
                        return Float.valueOf(n);
                    }
                    case 6: {
                        return (double)n;
                    }
                }
            }
            case 4: {
                long l = (Long)o;
                switch (srcType) {
                    case 0: {
                        return (byte)l;
                    }
                    case 1: {
                        return Character.valueOf((char)l);
                    }
                    case 2: {
                        return (short)l;
                    }
                    case 3: {
                        return (int)l;
                    }
                    case 4: {
                        return l;
                    }
                    case 5: {
                        return Float.valueOf(l);
                    }
                    case 6: {
                        return (double)l;
                    }
                }
            }
            case 5: {
                float f = ((Float)o).floatValue();
                switch (srcType) {
                    case 0: {
                        return (byte)f;
                    }
                    case 1: {
                        return Character.valueOf((char)f);
                    }
                    case 2: {
                        return (short)f;
                    }
                    case 3: {
                        return (int)f;
                    }
                    case 4: {
                        return (long)f;
                    }
                    case 5: {
                        return Float.valueOf(f);
                    }
                    case 6: {
                        return (double)f;
                    }
                }
            }
            case 6: {
                double d = (Double)o;
                switch (srcType) {
                    case 0: {
                        return (byte)d;
                    }
                    case 1: {
                        return Character.valueOf((char)d);
                    }
                    case 2: {
                        return (short)d;
                    }
                    case 3: {
                        return (int)d;
                    }
                    case 4: {
                        return (long)d;
                    }
                    case 5: {
                        return Float.valueOf((float)d);
                    }
                    case 6: {
                        return d;
                    }
                }
            }
        }
        return o;
    }
}

