/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.jpmobileutil;

import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.jpmobileutil.Display;
import jp.sourceforge.jpmobileutil.enums.Carrier;
import jp.sourceforge.jpmobileutil.exception.UnknownMobileException;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;

public abstract class Mobile {
    private static final Logger logger = Logger.getLogger(Mobile.class);
    protected Carrier carrier;
    protected Display display;
    protected Perl5Util matcher = new Perl5Util();
    protected String model;
    protected String name;
    protected String rawModel;
    protected String userAgent;
    protected String version;

    protected void create(HttpServletRequest request) throws UnknownMobileException {
        this.userAgent = request.getHeader("User-Agent");
        this.setHeaders(request);
        this.parse();
    }

    public String getCarrierLongName() {
        return this.carrier.getName();
    }

    public String getCarrierShortName() {
        return this.carrier.getShortName();
    }

    public Display getDisplay() {
        if (this.display == null) {
            return this.makeDisplay();
        }
        return this.display;
    }

    public String getModel() {
        if (this.model == null) {
            return this.rawModel;
        }
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isAirHPhone() {
        return false;
    }

    public boolean isDoCoMo() {
        return false;
    }

    public boolean isEZweb() {
        return false;
    }

    public boolean isJPhone() {
        return false;
    }

    public boolean isNonMobile() {
        return false;
    }

    public boolean isSoftBank() {
        return false;
    }

    public boolean isTuKa() {
        return false;
    }

    public boolean isVodafone() {
        return false;
    }

    public boolean isWAP1() {
        return this.isEZweb() && !this.isWAP2();
    }

    public boolean isWAP2() {
        return this.isEZweb() && this.isXHTMLCompliant();
    }

    public boolean isWillcom() {
        return false;
    }

    public boolean isXHTMLCompliant() {
        return false;
    }

    protected abstract Display makeDisplay();

    protected abstract void parse() throws UnknownMobileException;

    protected void setHeaders(HttpServletRequest request) {
    }
}

