/**
 * brownie-lang.js
 * 
 * uses
 *  ;
 * @author T.Akima
 * @copyright T.Akima
 * @license LGNU
 */

<!-- 


/**************************************************************
 * EventWrapper
 * IẼCxgDOM level 2̃Cxgɂ킹̂ړIB
 **************************************************************/
function EventWrapper( e ) {
	this._impl = e;
	this.target = e.srcElement;
	for(var prop in e)
		this[prop] = e[prop]; //vpeBA\bhRs[
	this.keyCode = (e.keyCode != 0) ? e.keyCode : e.charCode;
	this.isEventWrapper = true;
	
	this.stopPropagation = function() {
		throw new Error('unsupported'); 
	}
	
	this.preventDefault = function() {
		this._impl.cancelBubble = true;
		this._impl.returnValue = false;
		return false;
	}
	
}

/**************************************************************
 * XBrowser
 * class for CrossBrowsing
 **************************************************************/
function XBrowser(){
	var is_major=parseInt(navigator.appVersion);
	this.nver = is_major;
	this.ver = navigator.appVersion;
	this.dom = document.getElementById ? true : false;
	this.agent = navigator.userAgent;
	this.opera = window.opera ? true : false;
	this.opera7 = ((this.agent.toLowerCase().indexOf('opera 7')>-1) || (this.agent.toLowerCase().indexOf('opera/7')>-1));
	this.operaOld = this.opera&&!this.opera7;
	this.ie5 = (this.ver.indexOf("MSIE 5")>-1&&this.dom&&!this.opera);
	this.ie6 = (this.ver.indexOf("MSIE 6")>-1&&this.dom&&!this.opera);
	this.ie4 = (document.all&&!this.dom&&!this.opera);
	this.ie =  this.ie4||this.ie5||this.ie6;
	this.mac = this.agent.indexOf("Mac")>-1;
	this.ff = this.agent.indexOf("Firefox") > -1;
	this.nn6 = (this.dom&&(parseInt(this.ver)>=5)&&(! this.ff));
	this.ie3 = (this.ver.indexOf("MSIE")&&(is_major<4));
	this.hotjava = (this.agent.toLowerCase().indexOf('hotjava')!=-1);
	this.nn4 = (document.layers&&!this.dom&&!this.hotjava) ? true : false;
	this.bw = (this.ie6||this.ie5||this.ie4||this.nn4||this.nn6||this.opera);
	this.ver3 = (this.hotjava||this.ie3);
	
	this.toString = function(){
		return "nver=" + this.nver 
			+" ver=" + this.ver
			+" dom=" + this.dom
			+" ie=" + this.ie
			+" ie3=" + this.ie3
			+" ie4=" + this.ie4
			+" ie5=" + this.ie5
			+" ie6=" + this.ie6
			+" nn4=" + this.nn4
			+" nn6=" + this.nn6
			+" mac=" + this.mac
			+" hotjava=" + this.hotjava
			+" bw=" + this.bw
			+" ver3=" + this.ver3
			+" opera=" + this.opera
			+" opera7=" + this.opera7
			+" operaOld=" + this.operaOld
			+" ff=" + this.ff
			+" agent=" + this.agent;
	}
	
	
	
	/*----------------------------------------------------------*
	 * ^O֌W
	 *----------------------------------------------------------*/
	this.getTag = function(name){
		return this.nn4 ? document.layers[name] :
			(document.all) ? document.all[name] : 
			document.getElementById(name);
	}
	
	/*----------------------------------------------------------*
	 * Div֌W
	 *----------------------------------------------------------*/
	this.getDiv = function(name){
		return this.getTag(name);
	}
	
	this.getDivLeft = function(div){
		return (this.ie4) ? div.style.pixelLeft :
			(this.nn4) ? div.left :
			//(this.ff) ? div.offsetLeft :
			div.offsetLeft;
	}
	
	this.getDivTop = function(div){
		return (this.ie4) ? div.style.pixelTop :
			(this.nn4) ? div.top :
			//(this.ff) ? div.offsetTop :
			div.offsetTop;
	}
	
	
	this.getDivWidth = function(div){
		return (this.ie4) ? div.style.pixelWidth :
			(this.nn4) ? div.width :
			div.offsetWidth;
	}
	
	this.getDivHeight = function(div){
		return (this.ie4) ? div.style.pixelHeight :
			(this.nn4) ? div.height :
			div.offsetHeight;
	}
	
	
	this.getDivVisibility = function(div){
		if (this.nn4) {
			return (div.visibility == 'inherit');
		//} else if (this.ff) {
		//	return (div.style.visibility == 'inherit') || (div.style.visibility == 'visible');
		} else {
			return (div.style.visibility != 'hidden');
		}
	}
	
	this.setDivVisibility = function(div, visible){
		if (this.nn4) {
			div.visibility = (visible) ? 'inherit' : 'hide';
		} else {
			div.style.visibility = (visible) ? 'inherit' : 'hidden';
		}
	}
	
	this.moveDivTo = function(div,left,top){
		if (this.nn6) {
	    div.style.left=left+'px';
	    div.style.top =top +'px';
	    return;
	  }
		if (this.ie) {
	    div.style.pixelLeft=left;
	    div.style.pixelTop =top;
	    return;
	  }
		if (this.nn4) {
	    div.moveTo(left,top);
	    return;
	  }
	}
	
	this.moveDivBy = function(div, left, top){
		if (this.nn6) {
	    div.style.left=div.offsetLeft+left;
	    div.style.top =div.offsetTop +top;
	    return;
		}
		if (this.ie5) {
	    div.style.pixelLeft=div.offsetLeft+left;
	    div.style.pixelTop =div.offsetTop +top;
	    return;
		}
		if (this.ie4) {
	    div.style.pixelLeft+=left;
	    div.style.pixelTop +=top;
	    return;
		}
		if (this.nn4) {
	    div.moveBy(left,top);
	    return;
		}
	}
	
	this.initDivPos = function(div){
	  if(this.nn6){
	    div.style.left = div.offsetLeft+'px';
	    div.style.top  = div.offsetTop +'px';
	  } else if(this.ie){
	    div.style.pixelLeft = div.offsetLeft;
	    div.style.pixelTop  = div.offsetTop;
	  }
	  return div;
	}
	
	/*----------------------------------------------------------*
	 * Cxg֌W
	 *----------------------------------------------------------*/
	
	this.exitEvent = function(e) {
		if (isDefined(e.isEventWrapper) && e.isEventWrapper) {
			e.preventDefault();
			return false;
		} else if (isDefined(e.cancelable) && e.cancelable) {
			e.preventDefault();
			return false;
		} else {
			e.cancelBubble = true;
			e.returnValue = false;
			return false;
		}
	}
	
	/**
	 * DOM level 2EventTargetC^tF[X郁\bhB
	 * ړIIEaddEventListenerȂǂg悤ɂ邱ƁB
	 * 炱̃\bh̒Œ`̂́ÂƂSIEpB
	 */
	this.prepareEventTargetInterface = function( element ) {
		if (! this.ie )
			return ;
		proxy_addEventListener = function(_eventType, _function, _bubble) {
		  this.attachEvent("on"+ _eventType, 
		  	function() {
   				var eWrapper = new EventWrapper(event);
   				return _function(eWrapper);
	   		}
	   	);
		}
		proxy_removeEventListener = function(_eventType, _function, _bubble) {
  		this.detachEvent("on"+_eventType, _function);
		}
		
		if (!isDefined(element.addEventListener))
			element.addEventListener = proxy_addEventListener;
		if (!isDefined(element.removeEventListener))
	 		element.removeEventListener = proxy_removeEventListener;
	}
	
	this.prepareWithChildren = function( elements ) {
		for (var i = 0; i < elements.length; i++){
			var element = elements[i];
			try {
				this.prepareEventTargetInterface( element );
			} catch(e) {
				//ȂɂȂ
			}
			if (isDefined(element.childNodes)) {
				//this.prepareWithChildren( element.childNodes );
			}
		}
	}
	/**
	 * Cxgn
	 * IEaddEventListenerg悤ɂ邾B
	 * 炱̃\bh̒Œ`̂́ÂƂSIEpB
	 */
	this.initDocument = function( doc ) {
		if (! this.ie )
			return ;
		this.prepareEventTargetInterface( window );
		this.prepareWithChildren(doc.getElementsByTagName("*"));
	}
	
	
	/*----------------------------------------------------------*
	 * J[\֌W
	 *----------------------------------------------------------*/
	this.getCursorLeft = function( e ){
		return (this.nn6) ? e.clientX + window.scrollX :
			(this.nn4) ? e.pageX : 
			(this.ie) ? document.body.scrollLeft + window.event.clientX : 
			(this.ff) ? document.body.scrollLeft + e.clientX : 
			e.clientX;
	}
	
	this.getCursorTop = function( e ){
		return (this.nn6) ? e.clientY + window.scrollY :
			(this.nn4) ? e.pageY : 
			(this.ie) ? document.body.scrollTop + window.event.clientY : 
			(this.ff) ? document.body.scrollTop + e.clientY : 
			e.clientY;
	}
	
	this.getCursorHand = function(){
		return this.ff ? "pointer" : "hand";
	}
	
	/*----------------------------------------------------------*
	 * L[֌W
	 *----------------------------------------------------------*/
	this.getKeyCode = function(e){
		var eventType = e.type;
		if (isDefined(e.isEventWrapper) && e.isEventWrapper) {
			return e.keyCode;
		} else if (this.nn4) {
			return e.which;
		} else if (this.ff) {
			if (eventType == "keypress") {
				alert( "!!!!!warning!!!!! firefoxkeypressCxgłkeyCode𐳂擾ł܂!!!" );
				return 0;
			}
			return (e.keyCode != 0) ? e.keyCode : e.which;
		} else {
			if (eventType == "keypress") {
				alert( "!!!!!warning!!!!! IEkeypressCxgłkeyCode𐳂擾ł܂!!!" );
				return 0;
			}
			return (e.keyCode != 0) ? e.keyCode : e.charCode;
		}
	}
	
	/*----------------------------------------------------------*
	 * tH[JX֌W
	 *----------------------------------------------------------*/
	this.getFocused = function( doc ) {
		if (this.ie) {
			return doc.activeElement;
		} else {
			//IEȊO͂ǂׂ΂̂ȂB
			return null; 
		}
	}

}

/** XBrowser̃CX^X */
var xBrowser = new XBrowser();
//xBrowser.initDocument();


/**************************************************************
 * lLǂ𔻒f
 **************************************************************/
function isDefined(val){
	return ! isUndefined(val);
}

/**************************************************************
 * lǂ𔻒f
 **************************************************************/
function isUndefined(val){
	return typeof(val) == 'undefined';
}

/**************************************************************
 * Lȕ񂩂ǂ𔻒f
 **************************************************************/
function isAvail(str){
	return (! isUndefined(str)) && (str != null) && (str != "");
}


/**************************************************************
 * IuWFNg̒g𕶎
 **************************************************************/
function descProps( obj ){
	var s = null;
	for (var key in obj){
		if (s == null) {
			s = key +"="+ obj[key];
		} else {
			s = s + ", " + key +"="+ obj[key];
		}
	}
	return s;
}


/**************************************************************
 * ps֐
 **************************************************************/
function inherit(subClass, superClass) {
	for (var prop in superClass.prototype) {
		subClass.prototype[prop] = superClass.prototype[prop];
	}
}




/**************************************************************
 * ziArrayIuWFNgjgXg
 * ArrayƂ̈Ⴂ́AremoveƂlengthς
 **************************************************************/
function ArrayList(){
	this.initVariables();
}

ArrayList.prototype.initVariables = function(){
  this.array = new Array();
}

ArrayList.prototype.add = function( obj ){
	var oldArray = this.array;
	this.array = new Array(oldArray.length +1 );
	this.array[ oldArray.length ] = obj;
	for (var i = 0; i < oldArray.length; i++){
		this.array[i] = oldArray[i];
	}
	return this.array.length;
}

ArrayList.prototype.addAll = function( collection ){
	for(var i = 0; i < collection.size(); i++){
		this.add(collection.get(i));
	}
}

ArrayList.prototype.clear = function(){
	this.array = new Array( 0 );
}

ArrayList.prototype.contain = function( obj ){
	var idx = this.indexOf( obj );
	return ( idx != -1 );
}

ArrayList.prototype.get = function( index ){
	return this.array[ index ];
} 

ArrayList.prototype.indexOf = function( obj ){
	for (var i = 0; i < this.array.length; i++){
		if ( this.array[ i ] == obj){
			return i;
		}
	}
	return -1;
} 

ArrayList.prototype.isEmpty = function( obj ){
	var sz = this.size();
	return (sz == 0);
}

ArrayList.prototype.remove = function( obj ){
	var removeIndex = this.indexOf( obj );
	if (removeIndex == -1)
		return removeIndex;
	var oldArray = this.array;
	this.array = new Array(oldArray.length -1 );
	var destIndex = 0;
	for (var i = 0; i < oldArray.length; i++){
		if (i != removeIndex){
			this.array[destIndex] = oldArray[i];
			destIndex ++ ;
		}
	}
	return removeIndex;
}

ArrayList.prototype.size = function(){
	return this.array.length ;
}

ArrayList.prototype.toArray = function(){
	var result = new Array( this.size() );
	for (var i = 0; i <this.size(); i++){
		result[i] = this.get(i);
	}
	return result;
}


new ArrayList(); //pp̃_~[𐶐

/**************************************************************
 * Set
 **************************************************************/
function Set(){
	this.initVariables();
}

inherit(Set, ArrayList);

Set.prototype.super_add = Set.prototype.add;
Set.prototype.add = function( obj ){
	if (! obj)
		return;
	if (this.indexOf(obj) <0)
		this.super_add( obj );
}

/**************************************************************
 * }bv̗vf
 **************************************************************/
function MapEntry(key, value){
	this._key = key;
	this._value = value;
}
MapEntry.prototype.getKey = function(){
	return this._key;
}
MapEntry.prototype.getValue = function(){
	return this._value;
}
MapEntry.prototype.setValue = function(value){
	this._value = value;
}


/**************************************************************
 * }bv
 **************************************************************/
function Map() {
	this._entries = new ArrayList();
}
Map.prototype.clear = function(){
	this._entries.clear();
}

Map.prototype.get = function(key){
	var entry = this.getEntry(key);
	if (entry) {
		return entry.getValue();
	} else {
		return null;
	}
}

Map.prototype.getEntry = function(key){
	if (key == null){
		return null;
	}
	for(var i = 0; i < this._entries.size(); i++){
		var entry = this._entries.get(i);
		if (entry.getKey() == key){
			return entry;
		}
	}
	return null;
}

Map.prototype.keySet = function(){
	var result = new Set();
	for(var i = 0; i < this._entries.size(); i++){
		var entry = this._entries.get(i);
		result.add( entry.getKey() );
	}
	return result;
}

Map.prototype.put = function(key, value){
	if (key == null){
		return;
	}
	var entry = this.getEntry(key);
	if (entry) {
		entry.setValue( value );
	} else {
		this._entries.add(new MapEntry(key, value));
	}	
}


/**************************************************************
 * Map̃[eBeB֐
 **************************************************************/
/**
 * ^ȌW܂肩MapIuWFNg𐶐܂B
 * ȉ̃^Oꍇɂ́A
 * <a href="." onclick="selectRow(this); return false;">
 *   I
 *   <span id="value" title="a1"></span>
 * 	 <span id="value" title="b1"></span>
 *	 <span id="value" title="c1"></span>
 *   <span id="value" title="d1"></span>
 *   <span id="value" title="e1"></span>
 * </a>
 * var valueMap = buildMap(selected, "value", "title");
 * Ƃ邱Ƃa1,b1,c1,d1,e1L[ƂMapIuWFNg܂B
 */
function buildMap( ownerTag, targetTagId, keyAttrName){
	var result = new Map();
	var paramAttrs = ownerTag.childNodes;
	var prop = null;
	var dest = null;
	for(var j = 0; j < paramAttrs.length; j++){
		var p_child = paramAttrs.item(j);
		if (p_child.id == targetTagId){
			var key = p_child.getAttribute(keyAttrName);
			var value;
			try{
				value = p_child.firstChild.nodeValue;
				result.put(key, value);
			} catch(e){
				try{
					value = p_child.innerHTML;
					result.put(key, value);
				} catch(e){
					try{
						value = p_child.innerText;
						result.put(key, value);
					} catch(e){
						alert("G[: }bv̒l擾ł܂łBkey='" + key + "' :" + e);
					}
				}
			}
		}
	}
	return result;
}


/**************************************************************
 * Rg[idivȂǁjƕʂ̃IuWFNg̔ėp}bv
 **************************************************************/
var _controlToObject = new Map();







/**************************************************************
 * Oo͂邽߂̃NX
 **************************************************************/
var logger_enabled = true;

function LogWindow(name) {
	
	if (! logger_enabled){
		this.debug = function( msg ) {
			//Ȃ
		}
		this.debugObj = function( msg, obj ) {
			//Ȃ
		}
	} else {
	
		this._name = name;
		
		this._window = null;
		
		this.debug = function( msg ) {
			try{ 
				this._write(msg);
			} catch(e) {
				this._window = null;
				this._write(msg);
			}
		}
		
		this.debugObj = function( msg, obj ) {
			this.debug(msg);
			this.debug("------------- properties of [" +  typeof(obj) + "] -------------");
			for (var key in obj){
				this.debug(key +"="+ obj[key]);
			}
		}
		
		this._write = function( msg ){
			var w = this.getWindow();
			w.document.write( "<br/>" );
			w.document.write( this.formatDate( new Date() ) );
			w.document.write( " [" + this._name + "] ");
			w.document.write( msg );
			w.document.write( "\n" );
			w.scrollBy(0, 1000);
		}
		
		this.formatDate = function( d ){
			return d.getYear()+ "/"+
				(d.getMonth() + 1)+ "/"+
				d.getDate()+ " "+
				d.getHours() + ":" +
				d.getMinutes() + ":" +
				d.getSeconds() + ":" +
				d.getMilliseconds();
		}
		
		this.getWindow = function(){
			if (this._window == null){
				this._window = window.open('', this._name, "resizable=yes,scrollbars=yes,top=0,left=0");
				this._window.document.clear();
				this._window.document.write("<head><title>" + this._name + "</title></head>\n");
			} else if (this._window.closed){
				this._window.open();
			}
			return this._window;
		}
	}
}

var glogger = new LogWindow("global_logger");

/**************************************************************
 * z񃆁[eBeB
 **************************************************************/
function ArrayUtils() {
	this.newArray = function( arrays ) {
		var count = 0;
		for(var i = 0; i < arrays.length; i++) {
			count = count + arrays[i].length;
		}
		var result = new Array(count);
		var idx = 0;
		for(var i = 0; i < arrays.length; i++) {
			var array = arrays[i];
			for(var j = 0; j < array.length; j++) {
				result[idx] = array[j];
				idx++;
			}
		}
		return result;
	}
}

var arrayUtils = new ArrayUtils();


/**************************************************************
 * L[֌W
 **************************************************************/

VirtualKeyMap = new Map();

function VirtualKey(_code, _charCode, _charCodeShift) {
	this.code =  0;
	this.charCode = null;
	this.charCodeShift = null;
	
	this.code = _code;
	this.charCode = _charCode;
	this.charCodeShift = _charCodeShift;
	
	VirtualKeyMap.put(this.code, this);
}

KEY_CODE_CANCEL					= new VirtualKey(3, null, null);
KEY_CODE_HELP						= new VirtualKey(6, null, null);
KEY_CODE_BACK_SPACE			= new VirtualKey(8, null, null);
KEY_CODE_TAB						= new VirtualKey(9, null, null);
KEY_CODE_CLEAR					= new VirtualKey(12, null, null);
KEY_CODE_RETURN					= new VirtualKey(13, null, null);
KEY_CODE_ENTER					= new VirtualKey(14, null, null);
KEY_CODE_SHIFT					= new VirtualKey(16, null, null);
KEY_CODE_CONTROL				= new VirtualKey(17, null, null);
KEY_CODE_ALT						= new VirtualKey(18, null, null);
KEY_CODE_PAUSE					= new VirtualKey(19, null, null);
KEY_CODE_CAPS_LOCK			= new VirtualKey(20, null, null);
KEY_CODE_ESCAPE					= new VirtualKey(27, null, null);
KEY_CODE_SPACE					= new VirtualKey(32, 32, 32);
KEY_CODE_PAGE_UP				= new VirtualKey(33, null, null);
KEY_CODE_PAGE_DOWN			= new VirtualKey(34, null, null);
KEY_CODE_END						= new VirtualKey(35, null, null);
KEY_CODE_HOME						= new VirtualKey(36, null, null);
KEY_CODE_LEFT						= new VirtualKey(37, null, null);
KEY_CODE_UP							= new VirtualKey(38, null, null);
KEY_CODE_RIGHT					= new VirtualKey(39, null, null);
KEY_CODE_DOWN						= new VirtualKey(40, null, null);
KEY_CODE_PRINTSCREEN		= new VirtualKey(44, null, null);
KEY_CODE_INSERT					= new VirtualKey(45, null, null);
KEY_CODE_DELETE					= new VirtualKey(46, null, null);
KEY_CODE_0							= new VirtualKey(48, null, null);
KEY_CODE_1							= new VirtualKey(49, 49, 33);
KEY_CODE_2							= new VirtualKey(50, 50, 34);
KEY_CODE_3							= new VirtualKey(51, 51, 35);
KEY_CODE_4							= new VirtualKey(52, 52, 36);
KEY_CODE_5							= new VirtualKey(53, 53, 37);
KEY_CODE_6							= new VirtualKey(54, 54, 38);
KEY_CODE_7							= new VirtualKey(55, 55, 39);
KEY_CODE_8							= new VirtualKey(56, 56, 40);
KEY_CODE_9							= new VirtualKey(57, 57, 41);
KEY_CODE_COLON					= new VirtualKey(59, 58, 42);
//KEY_CODE_EQUALS					= new VirtualKey(60, '=', '-'); //???
KEY_CODE_SEMICOLON			= new VirtualKey(61, 59, 43);
KEY_CODE_A							= new VirtualKey(65, 97, 65);
KEY_CODE_B							= new VirtualKey(66, 98, 66);
KEY_CODE_C							= new VirtualKey(67, 99, 67);
KEY_CODE_D							= new VirtualKey(68, 100, 68);
KEY_CODE_E							= new VirtualKey(69, 101, 69);
KEY_CODE_F							= new VirtualKey(70, 102, 70);
KEY_CODE_G							= new VirtualKey(71, 103, 71);
KEY_CODE_H							= new VirtualKey(72, 104, 72);
KEY_CODE_I							= new VirtualKey(73, 105, 73);
KEY_CODE_J							= new VirtualKey(74, 106, 74);
KEY_CODE_K							= new VirtualKey(75, 107, 75);
KEY_CODE_L							= new VirtualKey(76, 108, 76);
KEY_CODE_M							= new VirtualKey(77, 109, 77);
KEY_CODE_N							= new VirtualKey(78, 110, 78);
KEY_CODE_O							= new VirtualKey(79, 111, 79);
KEY_CODE_P							= new VirtualKey(80, 112, 80);
KEY_CODE_Q							= new VirtualKey(81, 113, 81);
KEY_CODE_R							= new VirtualKey(82, 114, 82);
KEY_CODE_S							= new VirtualKey(83, 115, 83);
KEY_CODE_T							= new VirtualKey(84, 116, 84);
KEY_CODE_U							= new VirtualKey(85, 117, 85);
KEY_CODE_V							= new VirtualKey(86, 118, 86);
KEY_CODE_W							= new VirtualKey(87, 119, 87);
KEY_CODE_X							= new VirtualKey(88, 120, 88);
KEY_CODE_Y							= new VirtualKey(89, 121, 89);
KEY_CODE_Z							= new VirtualKey(90, 122, 90);
KEY_CODE_CONTEXT_MENU		= new VirtualKey(93, null, null);
KEY_CODE_NUMPAD0				= new VirtualKey(96, 48, 48);
KEY_CODE_NUMPAD1				= new VirtualKey(97, 49, 49);
KEY_CODE_NUMPAD2				= new VirtualKey(98, 50, 50);
KEY_CODE_NUMPAD3				= new VirtualKey(99, 51, 51);
KEY_CODE_NUMPAD4				= new VirtualKey(100, 52, 52);
KEY_CODE_NUMPAD5				= new VirtualKey(101, 53, 53);
KEY_CODE_NUMPAD6				= new VirtualKey(102, 54, 54);
KEY_CODE_NUMPAD7				= new VirtualKey(103, 55, 55);
KEY_CODE_NUMPAD8				= new VirtualKey(104, 56, 56);
KEY_CODE_NUMPAD9				= new VirtualKey(105, 57, 57);
KEY_CODE_MULTIPLY				= new VirtualKey(106, 42, 42);
KEY_CODE_ADD						= new VirtualKey(107, 43, 43);
KEY_CODE_SEPARATOR			= new VirtualKey(108, 44, 44);
KEY_CODE_SUBTRACT				= new VirtualKey(109, 45, 45);
KEY_CODE_DECIMAL				= new VirtualKey(110, 46, 46);
KEY_CODE_DIVIDE					= new VirtualKey(111, 47, 47);
KEY_CODE_F1							= new VirtualKey(112, null, null);
KEY_CODE_F2							= new VirtualKey(113, null, null);
KEY_CODE_F3							= new VirtualKey(114, null, null);
KEY_CODE_F4							= new VirtualKey(115, null, null);
KEY_CODE_F5							= new VirtualKey(116, null, null);
KEY_CODE_F6							= new VirtualKey(117, null, null);
KEY_CODE_F7							= new VirtualKey(118, null, null);
KEY_CODE_F8							= new VirtualKey(119, null, null);
KEY_CODE_F9							= new VirtualKey(120, null, null);
KEY_CODE_F10						= new VirtualKey(121, null, null);
KEY_CODE_F11						= new VirtualKey(122, null, null);
KEY_CODE_F12						= new VirtualKey(123, null, null);
KEY_CODE_F13						= new VirtualKey(124, null, null);
KEY_CODE_F14						= new VirtualKey(125, null, null);
KEY_CODE_F15						= new VirtualKey(126, null, null);
KEY_CODE_F16						= new VirtualKey(127, null, null);
KEY_CODE_F17						= new VirtualKey(128, null, null);
KEY_CODE_F18						= new VirtualKey(129, null, null);
KEY_CODE_F19						= new VirtualKey(130, null, null);
KEY_CODE_F20						= new VirtualKey(131, null, null);
KEY_CODE_F21						= new VirtualKey(132, null, null);
KEY_CODE_F22						= new VirtualKey(133, null, null);
KEY_CODE_F23						= new VirtualKey(134, null, null);
KEY_CODE_F24						= new VirtualKey(135, null, null);
KEY_CODE_NUM_LOCK				= new VirtualKey(144, null, null);
KEY_CODE_SCROLL_LOCK		= new VirtualKey(145, null, null);
KEY_CODE_COLON2					= new VirtualKey(186, 58, 42);
KEY_CODE_SEMICOLON2			= new VirtualKey(187, 59, 43);
KEY_CODE_COMMA					= new VirtualKey(188, 44, 60);
KEY_CODE_HYPHEN					= new VirtualKey(189, 45, 61);
KEY_CODE_PERIOD					= new VirtualKey(190, 46, 62);
KEY_CODE_SLASH					= new VirtualKey(191, 47, 63);
KEY_CODE_BACK_QUOTE			= new VirtualKey(192, 64, 96);
KEY_CODE_OPEN_BRACKET		= new VirtualKey(219, 91, 123);
KEY_CODE_BACK_SLASH1		= new VirtualKey(220, 92, 124);
KEY_CODE_CLOSE_BRACKET	= new VirtualKey(221, 93, 125);
KEY_CODE_QUOTE					= new VirtualKey(222, 94, 126);
KEY_CODE_META						= new VirtualKey(224, null, null);
KEY_CODE_BACK_SLASH2		= new VirtualKey(226, 92, 95);
KEY_CODE_IME_ON					= new VirtualKey(243, null, null);
KEY_CODE_IME_OFF 				= new VirtualKey(244, null, null);

KEY_CODE_ATMARK					= KEY_CODE_BACK_QUOTE;

/********************************************************
 * L[[eBeB
 ********************************************************/
function KeyUtils() {

	/**
	 * L[R[hǂ𒲂ׂ
	 */
	this.isControlKeyCode = function( keyCode ) {
		var key = VirtualKeyMap.get(keyCode);
		if (key == null)
			return true;
		return (key.charCode == null);
	}

	/**
	 * L[Cxgœ͂ꂽԂ
	 */
	this.toCharCode = function(e){
		var result = xBrowser.getKeyCode(e);
		if ((e.type != "keydown") && (e.type != "keyup")){
			return result;
		}
		var key = VirtualKeyMap.get(result);
		if (key == null){
			alert("L[܂łBkeyCode=" + result);
			return result;
		}
		return (e.shiftKey) ? key.charCodeShift : key.charCode;
	}
}

keyUtils = new KeyUtils();


/********************************************************
 * ֌W 萔
 ********************************************************/
HANKAKU_NUMBERS = new Array(
		"0","1","2","3","4","5","6","7","8","9");
HANKAKU_ALPHABETS_LOWER = new Array(
		"a","b","c","d","e","f","g","h","i","j","k","l","m",
		"n","o","p","q","r","s","t","u","v","w","x","y","z");
HANKAKU_ALPHABETS_UPPER = new Array(
		"A","B","C","D","E","F","G","H","I","J","K","L","M",
		"N","O","P","Q","R","S","T","U","V","W","X","Y","Z");
HANKAKU_ALPHABETS = arrayUtils.newArray( 
		new Array(HANKAKU_ALPHABETS_LOWER, HANKAKU_ALPHABETS_UPPER) );
HANKAKU_SYMBOLS = new Array(
		'\\','"',"'","-","^","@","[",";",":","]",",",".","/","!","#","$",
		"%","&","(",")","=","~","|","`","{","+","*","}","<",">","?","_");
HANKAKU_SPACE = new Array(" "," ");

ZENKAKU_NUMBERS = new Array("O","P","Q","R","S","T","U","V","W","X");
ZENKAKU_ALPHABETS_LOWER = new Array(
		"","","","","","","","","","","","","",
		"","","","","","","","","","","","","");
ZENKAKU_ALPHABETS_UPPER = new Array(
		"`","a","b","c","d","e","f","g","h","i","j","k","l",
		"m","n","o","p","q","r","s","t","u","v","w","x","y");
ZENKAKU_ALPHABETS = arrayUtils.newArray(
		new Array(ZENKAKU_ALPHABETS_LOWER, ZENKAKU_ALPHABETS_UPPER) );
ZENKAKU_SYMBOLS = new Array(
		"","h","f","|","O","","m","G","F","n","C","D","^","I","","",
		"","","i","j","","P","b","M","o","{","","p","","","H","Q");
ZENKAKU_SPACE = new Array("@","@");

HANKAKU_KANA = new Array(
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"",
		"","","","","",
		"","","",
		"","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","",
		"","","","","",
		"","");
ZENKAKU_KANA = new Array(
		"K","M","O","Q","S",
		"U","W","Y","[","]",
		"_","a","d","f","h",
		"o","r","u","x","{",
		"p","s","v","y","|",
		"",
		"@","B","D","F","H",
		"","","",
		"b","[",
		"A","C","E","G","I",
		"J","L","N","P","R",
		"T","V","X","Z","\",
		"^","`","c","e","g",
		"i","j","k","l","m",
		"n","q","t","w","z",
		"}","~","","","",
		"","","",
		"","","","","",
		"","");
ZENKAKU_HIRA = new Array(
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"",
		"","","","","",
		"","","",
		"","[",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","","","",
		"","","",
		"","","","","",
		"","");

/********************************************************
 * 񃆁[eBeB
 ********************************************************/
function StringUtils(){

	/**
	 * t\ۂ𔻒fB
	 * valueacceptableɊ܂܂ȂꍇfalseA
	 * value\镶񂪑SacceptableɊ܂܂ꍇtrueB
	 * valuenullȂtrueAacceptablenullȂfalseB
	 */
	this.checkStringAcceptable = function( value, acceptable ) {
		if (value == null)
			return true;
		if (acceptable == null)
			return false;
		for (var i = 0; i < value.length ; i++) {
			if (acceptable.indexOf(value.charAt(i)) == -1) 
				return false;
		}
		return true;
	}

	/**
	 * 񂪊kǂ𔻒f
	 */
	this.isEmpty = function( value ) {
		if (value == null)
			return true;
		if (value.length == 0)
			return true;
		return false;
	}

	/**
	 * ̃LR[hǂ𒲂ׂ
	 * 0`9: 48`57
	 */
	this.isNumberCharCode = function( charCode ) {
		return (48 <=charCode && charCode <= 57);
	}

	/**
	 * 啶̃At@xbg̃LR[hǂ𒲂ׂ
	 * A`Z: 65`90
	 */
	this.isUpperAlphabetCharCode = function( charCode ) {
		return (65 <=charCode && charCode <= 90);
	}

	/**
	 * ̃At@xbg̃LR[hǂ𒲂ׂ
	 * a`z97`122
	 */
	this.isLowerAlphabetCharCode = function( charCode ) {
		return (97 <=charCode && charCode <= 122);
	}
	

	/**
	 * At@xbg̃LR[hǂ𒲂ׂ
	 * A`Z: 65`90
	 * a`z97`122
	 */
	this.isAlphabetCharCode = function( charCode ) {
		return this.isUpperAlphabetCharCode( charCode ) ||  this.isLowerAlphabetCharCode( charCode );
	}

	/**
	 * w肵ނɊ܂܂Ă邩ǂ𒲂ׂ
	 */
	this.includeChar = function( achar, typeArray ) {
		for(var i = 0; i < typeArray.length; i++) {
			if (achar == typeArray[i]){
				//glogger.debug("StringUtils.includeChar achar=" + achar + " typeArray[i]=" + typeArray[i]);
				return true;
			}
		}
		return false;
	}

	this.replaceChars = function( value, regExp, searchFor, replaceWith ) {
		if (searchFor.length != replaceWith.length) {
			alert("different length between searchFor and replaceWith");
			return null;
		}
		var str = value;
		if (regExp == null) {
			for(var i = 0; i < searchFor.length; i++){
				str = str.replace(searchFor[i], replaceWith[i]);
			}
		} else {
			// while(str.match(regExp)){
				for(var i = 0; i < searchFor.length; i++){
					str = str.replace(searchFor[i], replaceWith[i]);
				}
			// }
		}
		return str;
	}

	/**
	 * ɔp̐܂܂ĂꍇɂSp̐ɕϊ
	 */
	this.toZenkakuNumber = function( value ){
		return this.replaceChars(value, /[0-9]/, HANKAKU_NUMBERS, ZENKAKU_NUMBERS);
	}
	this.toHankakuNumber = function( value ){
		return this.replaceChars(value, /[O-X]/, ZENKAKU_NUMBERS, HANKAKU_NUMBERS);
	}

	/**
	 * ɔp̃At@xbg܂܂ĂꍇɂSp̃At@xbgɕϊ
	 */
	this.toZenkakuAlphabet = function( value ){
		return this.replaceChars(value, /[a-zA-Z]/, HANKAKU_ALPHABETS, ZENKAKU_ALPHABETS);
	}
	this.toHankakuAlphabet = function( value ){
		return this.replaceChars(value, /[-`-y]/, ZENKAKU_ALPHABETS, HANKAKU_ALPHABETS);
	}

	/**
	 * ɔp̃Ji܂܂ĂꍇɂSp̃Jiɕϊ
	 */
	this.toZenkakuKana = function( value ){
		return this.replaceChars(value, /[-]/, HANKAKU_KANA, ZENKAKU_KANA);
	}
	this.toHankakuKana = function( value ){
		var result = value;
		result = this.toHankakuKanaKatakana(result);
		result = this.toHankakuKanaHiragana(result);
		return result;
	}
	this.toHankakuKanaKatakana = function( value ){
		return this.replaceChars(value, /[-]/, ZENKAKU_KANA, HANKAKU_KANA);
	}
	this.toHankakuKanaHiragana = function( value ){
		return this.replaceChars(value, /[-]/, ZENKAKU_HIRA, HANKAKU_KANA);
	}

	/**
	 * ɔp̋L܂܂ĂꍇɂSp̋Lɕϊ
	 */
	this.toZenkakuSymbol = function( value ){
		return this.replaceChars(value, null, HANKAKU_SYMBOLS, ZENKAKU_SYMBOLS);
	}
	this.toHankakuSymbol = function( value ){
		return this.replaceChars(value, null, ZENKAKU_SYMBOLS, HANKAKU_SYMBOLS);
	}

	/**
	 * ɔp̃Xy[X܂܂ĂꍇɂSp̃Xy[Xɕϊ
	 */
	this.toZenkakuSpace = function( value ){
		return this.replaceChars(value, null, HANKAKU_SPACE, ZENKAKU_SPACE);
	}
	this.toHankakuSpace = function( value ){
		return this.replaceChars(value, null, ZENKAKU_SPACE, HANKAKU_SPACE);
	}

	/**
	 * ɔp̕܂܂ĂꍇɂSp̕ɕϊ
	 */
	this.toZenkaku = function( value ){
		var result = value;
		result = this.toZenkakuKana(result);
		result = this.toZenkakuNumber(result);
		result = this.toZenkakuAlphabet(result);
		result = this.toZenkakuSymbol(result);
		result = this.toZenkakuSpace(result);
		return result;
	}

	this.toHankaku = function( value ){
		var result = value;
		result = this.toHankakuKana(result);
		result = this.toHankakuNumber(result);
		result = this.toHankakuAlphabet(result);
		result = this.toHankakuSymbol(result);
		result = this.toHankakuSpace(result);
		return result;
	}
}

stringUtils = new StringUtils();



/********************************************************
 * R|[lg [eBeB
 ********************************************************/
function ControlUtils() {
	this.getLabelFor = function( field ) {
		var labels = document.getElementsByTagName("label");
		for(var i = 0; i < labels.length; i++) {
			var label = labels[i];
			if (label.htmlFor == field.id)
				return label;
		}
		return null;
	}
}

controlUtils = new ControlUtils();
-->