/**
 * brownie-ime.js
 * 
 * uses 
 *  brownie-lang.js;
 *
 * @author T.Akima
 * @copyright T.Akima
 * @license LGNU
 */
<!-- 

ROMAJI_MAPS = new Array(5);
ROMAJI_MAPS[0] = null;
ROMAJI_MAPS[1] = new Map();
ROMAJI_MAPS[2] = new Map();
ROMAJI_MAPS[3] = new Map();
ROMAJI_MAPS[4] = new Map();

function _addTo_ROMAJI_MAPS(key, value){
	var keyLength = key.length;
	ROMAJI_MAPS[keyLength].put(key, value);
	if (keyLength > 1){
		var headChar = key.charAt(0);
		if ((headChar != 'l') && (headChar != 'x')){
			ROMAJI_MAPS[keyLength + 1].put(headChar + key, ""+ value);
		}
	}
	
}

function _initialize_ROMAJI_MAPS() {
	_addTo_ROMAJI_MAPS('a','');
	_addTo_ROMAJI_MAPS('i','');
	_addTo_ROMAJI_MAPS('u','');
	_addTo_ROMAJI_MAPS('e','');
	_addTo_ROMAJI_MAPS('o','');
	_addTo_ROMAJI_MAPS('ka','');
	_addTo_ROMAJI_MAPS('ki','');
	_addTo_ROMAJI_MAPS('ku','');
	_addTo_ROMAJI_MAPS('ke','');
	_addTo_ROMAJI_MAPS('ko','');
	_addTo_ROMAJI_MAPS('sa','');
	_addTo_ROMAJI_MAPS('shi','');
	_addTo_ROMAJI_MAPS('si',''); //
	_addTo_ROMAJI_MAPS('su','');
	_addTo_ROMAJI_MAPS('se','');
	_addTo_ROMAJI_MAPS('so','');
	_addTo_ROMAJI_MAPS('ta','');
	_addTo_ROMAJI_MAPS('chi','');
	_addTo_ROMAJI_MAPS('ti',''); //
	_addTo_ROMAJI_MAPS('tsu','');
	_addTo_ROMAJI_MAPS('tu',''); //
	_addTo_ROMAJI_MAPS('te','');
	_addTo_ROMAJI_MAPS('to','');
	_addTo_ROMAJI_MAPS('na','');
	_addTo_ROMAJI_MAPS('ni','');
	_addTo_ROMAJI_MAPS('nu','');
	_addTo_ROMAJI_MAPS('ne','');
	_addTo_ROMAJI_MAPS('no','');
	_addTo_ROMAJI_MAPS('ha','');
	_addTo_ROMAJI_MAPS('hi','');
	_addTo_ROMAJI_MAPS('fu','');
	_addTo_ROMAJI_MAPS('hu',''); //
	_addTo_ROMAJI_MAPS('he','');
	_addTo_ROMAJI_MAPS('ho','');
	_addTo_ROMAJI_MAPS('ma','');
	_addTo_ROMAJI_MAPS('mi','');
	_addTo_ROMAJI_MAPS('mu','');
	_addTo_ROMAJI_MAPS('me','');
	_addTo_ROMAJI_MAPS('mo','');
	_addTo_ROMAJI_MAPS('ya','');
	_addTo_ROMAJI_MAPS('yu','');
	_addTo_ROMAJI_MAPS('yo','');
	_addTo_ROMAJI_MAPS('ra','');
	_addTo_ROMAJI_MAPS('ri','');
	_addTo_ROMAJI_MAPS('ru','');
	_addTo_ROMAJI_MAPS('re','');
	_addTo_ROMAJI_MAPS('ro','');
	_addTo_ROMAJI_MAPS('wa','');
	_addTo_ROMAJI_MAPS('wo',''); //
	_addTo_ROMAJI_MAPS('nn',''); //
	//_addTo_ROMAJI_MAPS('n',''); //
	_addTo_ROMAJI_MAPS('ga','');
	_addTo_ROMAJI_MAPS('gi','');
	_addTo_ROMAJI_MAPS('gu','');
	_addTo_ROMAJI_MAPS('ge','');
	_addTo_ROMAJI_MAPS('go','');
	_addTo_ROMAJI_MAPS('za','');
	_addTo_ROMAJI_MAPS('ji','');
	_addTo_ROMAJI_MAPS('zi',''); //
	_addTo_ROMAJI_MAPS('zu','');
	_addTo_ROMAJI_MAPS('ze','');
	_addTo_ROMAJI_MAPS('zo','');
	_addTo_ROMAJI_MAPS('da','');
	_addTo_ROMAJI_MAPS('di',''); //
	_addTo_ROMAJI_MAPS('du',''); //
	_addTo_ROMAJI_MAPS('de','');
	_addTo_ROMAJI_MAPS('do','');
	_addTo_ROMAJI_MAPS('ba','');
	_addTo_ROMAJI_MAPS('bi','');
	_addTo_ROMAJI_MAPS('bu','');
	_addTo_ROMAJI_MAPS('be','');
	_addTo_ROMAJI_MAPS('bo','');
	_addTo_ROMAJI_MAPS('pa',''); //
	_addTo_ROMAJI_MAPS('pi',''); //
	_addTo_ROMAJI_MAPS('pu',''); //
	_addTo_ROMAJI_MAPS('pe',''); //
	_addTo_ROMAJI_MAPS('po',''); //
	_addTo_ROMAJI_MAPS('va',''); //
	_addTo_ROMAJI_MAPS('vi',''); //
	_addTo_ROMAJI_MAPS('vu',''); //
	_addTo_ROMAJI_MAPS('ve',''); //
	_addTo_ROMAJI_MAPS('vo',''); //
	_addTo_ROMAJI_MAPS('kya','');
	_addTo_ROMAJI_MAPS('kyu','');
	_addTo_ROMAJI_MAPS('kyo','');
	_addTo_ROMAJI_MAPS('sha','');
	_addTo_ROMAJI_MAPS('shu','');
	_addTo_ROMAJI_MAPS('sho','');
	_addTo_ROMAJI_MAPS('sya',''); //
	_addTo_ROMAJI_MAPS('syu',''); //
	_addTo_ROMAJI_MAPS('syo',''); //
	_addTo_ROMAJI_MAPS('cha','');
	_addTo_ROMAJI_MAPS('chu','');
	_addTo_ROMAJI_MAPS('cho','');
	_addTo_ROMAJI_MAPS('tya',''); //
	_addTo_ROMAJI_MAPS('tyu',''); //
	_addTo_ROMAJI_MAPS('tyo',''); //
	_addTo_ROMAJI_MAPS('nya','ɂ');
	_addTo_ROMAJI_MAPS('nyu','ɂ');
	_addTo_ROMAJI_MAPS('nyo','ɂ');
	_addTo_ROMAJI_MAPS('hya','Ђ');
	_addTo_ROMAJI_MAPS('hyu','Ђ');
	_addTo_ROMAJI_MAPS('hyo','Ђ');
	_addTo_ROMAJI_MAPS('mya','݂');
	_addTo_ROMAJI_MAPS('myu','݂');
	_addTo_ROMAJI_MAPS('myo','݂');
	_addTo_ROMAJI_MAPS('rya','');
	_addTo_ROMAJI_MAPS('ryu','');
	_addTo_ROMAJI_MAPS('ryo','');
	_addTo_ROMAJI_MAPS('gya','');
	_addTo_ROMAJI_MAPS('gyu','');
	_addTo_ROMAJI_MAPS('gyo','');
	_addTo_ROMAJI_MAPS('ja','');
	_addTo_ROMAJI_MAPS('ju','');
	_addTo_ROMAJI_MAPS('jo','');
	_addTo_ROMAJI_MAPS('jya',''); //
	_addTo_ROMAJI_MAPS('jyu',''); //
	_addTo_ROMAJI_MAPS('jyo',''); //
	_addTo_ROMAJI_MAPS('bya','т');
	_addTo_ROMAJI_MAPS('byu','т');
	_addTo_ROMAJI_MAPS('byo','т');
	_addTo_ROMAJI_MAPS('vya',''); //
	_addTo_ROMAJI_MAPS('vyu',''); //
	_addTo_ROMAJI_MAPS('vyo',''); //
	_addTo_ROMAJI_MAPS('pya','҂');
	_addTo_ROMAJI_MAPS('pyu','҂');
	_addTo_ROMAJI_MAPS('pyo','҂');
	_addTo_ROMAJI_MAPS('la',''); //
	_addTo_ROMAJI_MAPS('li',''); //
	_addTo_ROMAJI_MAPS('lu',''); //
	_addTo_ROMAJI_MAPS('le',''); //
	_addTo_ROMAJI_MAPS('lo',''); //
	_addTo_ROMAJI_MAPS('xa',''); //
	_addTo_ROMAJI_MAPS('xi',''); //
	_addTo_ROMAJI_MAPS('xu',''); //
	_addTo_ROMAJI_MAPS('xe',''); //
	_addTo_ROMAJI_MAPS('xo',''); //
	_addTo_ROMAJI_MAPS('ltu',''); //
	_addTo_ROMAJI_MAPS('ltsu',''); //
	_addTo_ROMAJI_MAPS('xtu',''); //
	//_addTo_ROMAJI_MAPS('xtsu',''); //̓_
	_addTo_ROMAJI_MAPS('lya',''); //
	_addTo_ROMAJI_MAPS('lyu',''); //
	_addTo_ROMAJI_MAPS('lyo',''); //
	_addTo_ROMAJI_MAPS('xya',''); //
	_addTo_ROMAJI_MAPS('xyu',''); //
	_addTo_ROMAJI_MAPS('xyo',''); //
}

_initialize_ROMAJI_MAPS();






/***************************************************************************************
 * IMEœ͂Sp̃Ji⊮
 ***************************************************************************************/
/**
 */
function KanaComplete(kanjiField) {
	this._kanjiField = kanjiField;
	
	this._work = "";
	
	this._romajiText = "";
	
	this.dokeyup = function( e ){
		var keyCode = xBrowser.getKeyCode( e );
		if (keyCode == KEY_CODE_BACK_SPACE.code){
			if (this._work.length > 0) {
				this._work = this._work.substr(0, this._work.length -1);
			} else {
				this._romajiText = this._romajiText.substr(0, this._romajiText.length -1);
			}
		} else if (keyCode == KEY_CODE_TAB.code){
			this._work = "";
		} else if (keyCode == KEY_CODE_CLEAR.code){
		} else if (keyCode == KEY_CODE_RETURN.code){
			this._romajiText = this._romajiText + this._work;
			this._work = "";
		} else if (keyCode == KEY_CODE_ENTER.code){
		} else if (keyCode == KEY_CODE_SPACE.code){
		} else if (keyCode == KEY_CODE_HOME.code){
		} else if (keyCode == KEY_CODE_LEFT.code){
		} else if (keyCode == KEY_CODE_RIGHT.code){
		} else if (keyCode == KEY_CODE_INSERT.code){
		} else if (keyCode == KEY_CODE_DELETE.code){
		} else if (keyCode == KEY_CODE_IME_ON.code){
		} else if (keyCode == KEY_CODE_IME_OFF.code){
			
		} else {
			var charCode = keyUtils.toCharCode(e);
			if (charCode == null) {
				return ;
			}
			var c = String.fromCharCode(charCode);
			if (! stringUtils.isAlphabetCharCode(charCode)) {
				this._romajiText = this._romajiText + this._work + c;
				this._work = "";
				return ;
			}
			if ((this._work == 'n') && (ROMAJI_MAPS[1].get(c) == null)) {
					this._romajiText = this._romajiText + ROMAJI_MAPS[2].get("nn");
					this._work = c;
			} else {
				this._work = this._work + c;
				var romaji = this.getRomaji(this._work);
				if (romaji != null) {
					this._work = "";
					this._romajiText = this._romajiText + romaji;
				}
			}
		}
	}
	
	this.getRomaji = function( value ) {
		if (value == null)
			return null;
		for(var i = ROMAJI_MAPS.length -1; i > 0; i--) {
			var result = ROMAJI_MAPS[i].get( value );
			if (result != null)
				return result;
		}
		return null;
	}
	
	this.getRomajiText = function() {
		return this._romajiText;
	}
	
}






-->