/**
 * brownie-ctrl.js
 * 
 * uses 
 *  brownie-lang.js
 *
 * @author T.Akima
 * @copyright T.Akima
 * @license LGPL
 */
<!-- 

//ech_attachMouseDragɓnindex
var draggingIndex = 0;


/***************************************************************************************
 * utility functions
 ***************************************************************************************/

/**
 * hbȎΏۂƂȂdivƃhbOdivw肷
 */
function registerDragging(dragPointDivId, draggedDivId){
	return new DraggablePanel(
		xBrowser.getTag(dragPointDivId), 
		xBrowser.getTag(draggedDivId), 
		draggingIndex++);
}

/**
 * JiBjyCidiv, span, trEEEjƂ𐧌䂷{^w肷
 */
function registerClosablePane(openBtnId, closeBtnId, paneId){
	return new ClosablePanes(
		xBrowser.getTag(openBtnId), 
		xBrowser.getTag(closeBtnId), 
		[paneId]);
}

/**
 * JiBjyCidiv, span, trEEEjƂ𐧌䂷{^w肷
 */
function registerClosablePanes(openBtnId, closeBtnId, paneIdArray){
	return new ClosablePanes(
		xBrowser.getTag(openBtnId), 
		xBrowser.getTag(closeBtnId), 
		paneIdArray);
}

/**
 * `FbN{^ȂǂŊJiBjyCidiv, span, trEEEjw肷
 * radioŎgp̂͂߂قƎv܂B
 * ȂȂonclickCxgł͒lς邱(checkedfalseɂȂ邱)擾łȂłB
 * radioƘAꍇRadioClosablePanesNXpB
 */
function registerCheckingClosablePane(checkable, paneId){
	return new CheckingClosablePanes(
		xBrowser.getTag(checkable), 
		[paneId]);
}

function registerCheckingClosablePaneReverse(checkable, paneId){
	return new CheckingClosablePanes(
		xBrowser.getTag(checkable), 
		[paneId],
		true);
}

/**
 * `FbN{^ȂǂŊJiBjyCidiv, span, trEEEjw肷
 * radioŎgp̂͂߂قƎv܂B
 * ȂȂonclickCxgł͒lς邱(checkedfalseɂȂ邱)擾łȂłB
 * radioƘAꍇRadioClosablePanesNXpB
 */
function registerCheckingClosablePanes(checkable, paneIdArray){
	return new CheckingClosablePanes(
		xBrowser.getTag(checkable), 
		paneIdArray);
}
function registerCheckingClosablePanesReverse(checkable, paneIdArray){
	return new CheckingClosablePanes(
		xBrowser.getTag(checkable), 
		paneIdArray,
		true);
}

/***************************************************************************************
 * Capture Events
 ***************************************************************************************/
function _captureMouseEvents(mouseMoveHandler, mouseDownHandler, mouseUpHandler) {
	document.onmousemove = mouseMoveHandler
  document.onmouseup = mouseUpHandler
  if(navigator.userAgent.indexOf('Gecko')!=-1)   //m1,n6p
    document.onmousedown = mouseDownHandler
  if(document.layers){                           //n4p
    document.captureEvents(Event.MOUSEMOVE)
    document.captureEvents(Event.MOUSEUP)
  }
}

/***************************************************************************************
 * DraggablePanel
 ***************************************************************************************/

/**
 * hbȎΏۂƂȂdivƃhbOdivw肷
 */
function DraggablePanel(dragPointDiv, draggedDiv, index) {
	var _titleBar = dragPointDiv;
	var _panel = draggedDiv;
	
	var dragging = false;
	var dragOffsetX = 0;
	var dragOffsetY = 0;
	
	this.titleBarMouseMove = function(e) {
		if (!dragging)
			return;
		var curX = xBrowser.getCursorLeft(e);
		var curY = xBrowser.getCursorTop(e);
		xBrowser.moveDivTo(_panel, curX - dragOffsetX, curY - dragOffsetY);
	}
	
	this.titleBarMouseDown = function(e) {
		dragging = true;
		var left = xBrowser.getDivLeft(_titleBar);
		var top = xBrowser.getDivTop(_titleBar);
		var curX = xBrowser.getCursorLeft(e);
		var curY = xBrowser.getCursorTop(e);
		dragOffsetX = curX - left
		dragOffsetY = curY - top;
	}
	
	this.titleBarMouseUp = function(e) {
		dragging = false;
		dragOffsetX = 0;
		dragOffsetY = 0;
	}
	
	
	/*
	 * Ȃ񂩂܂ȂǁAЂƂ܂ƂB
	 */
	
	//xBrowser.prepareEventTargetInterface( _titleBar );
	//_titleBar.style.cursor = "default";
	//_titleBar.addEventListener("mousedown", this.titleBarMouseDown, true);
	//_captureMouseEvents(
	//	this.titleBarMouseMove,
	//	null,
	//	this.titleBarMouseUp);
}


/***************************************************************************************
 * Pane Utility
 ***************************************************************************************/

function _setPanelDisplay(panelBodyIdArray, displayValue) {
	for (idx in panelBodyIdArray) {
		var panelName = panelBodyIdArray[idx];
		var p = xBrowser.getTag(panelName);
		if (p) {
			p.style.display = displayValue;
		}
	}
}

/***************************************************************************************
 * ClosablePanes
 ***************************************************************************************/

/**
 * ^Cgo[t̃pl𐧌䂷NX
 */
function ClosablePanes(openBtn, closeBtn, panelBodyIdArray) {
	var _openBtn = openBtn; 
	var _closeBtn = closeBtn;
	var _panelBodyIdArray = panelBodyIdArray;
	
	var _open = function() {
		_closeBtn.style.display = "inline";
		_openBtn.style.display = "none";
		_setPanelDisplay(_panelBodyIdArray, "block");
	}
	
	var _close = function() {
		_closeBtn.style.display = "none";
		_openBtn.style.display = "inline";
		_setPanelDisplay(_panelBodyIdArray, "none");
	}
	
	this.open = function() {
		_open();
	}
	
	this.close = function() {
		_close();
	}
	
	this.clickClose = function(e) {
		_close();
	}
	
	this.clickOpen = function(e) {
		_open();
	}
	
	
	xBrowser.prepareEventTargetInterface( _closeBtn );
	xBrowser.prepareEventTargetInterface( _openBtn );
	_closeBtn.style.cursor = "pointer";
	_openBtn.style.cursor = "pointer";
	_closeBtn.addEventListener("click", this.clickClose, true);
	_openBtn.addEventListener("click", this.clickOpen, true);
}




/***************************************************************************************
 * CheckingClosablePanes
 ***************************************************************************************/
/**
 * ^Cgo[t̃pl`FbN{bNXȂǂŐ䂷NX
 */
function CheckingClosablePanes(checkable, panelBodyIdArray, reverse) {
	
	var _reverse = isDefined(reverse) ? reverse : false;
	var _checkable = checkable; 
	var _panelBodyIdArray = panelBodyIdArray;
	
	var doOnClick = function() {
		var checkedValue = _checkable.checked;
		if (_reverse)
			checkedValue = ! checkedValue;
		if (checkedValue) {
			_open();
		} else {
			_close();
		}
	}
	
	var _open = function() {
		_setPanelDisplay(_panelBodyIdArray, "block");
	}
	
	var _close = function() {
		_setPanelDisplay(_panelBodyIdArray, "none");
	}
	
	this.open = function() {
		_open();
	}
	
	this.close = function() {
		_close();
	}
	
	this.checkableOnClick = function( e ) {
		doOnClick();
	}
	
	this.updateCheckable = function() {
		doOnClick();
	}
	
	xBrowser.prepareEventTargetInterface( _checkable );
	_checkable.addEventListener("click", this.checkableOnClick, true);
}

/***************************************************************************************
 * RadioClosablePanes
 ***************************************************************************************/

function RadioClosablePanes(){
	this._radioPaneMap = new Map();
	this._paneNameSet = new Set();
}

RadioClosablePanes.prototype.add = function(radioBtnId, mappedPaneNameArray) {
	var radioBtn = xBrowser.getTag(radioBtnId);
	if (! radioBtn){
		alert(radioBtnId + " was not found");
	}
	var pane = this;
	radioBtn.onclick = function(){
		pane.refresh();
	}
	this._radioPaneMap.put(radioBtn, mappedPaneNameArray);
	//
	for (i = 0; i < mappedPaneNameArray.length; i++) {
		var panelName = mappedPaneNameArray[i];
		this._paneNameSet.add( panelName );
	}
}

RadioClosablePanes.prototype.refresh = function() {
	_setPanelDisplay(this._paneNameSet.toArray(), "none");
	//
	var radios = this._radioPaneMap.keySet();
	for(var i = 0; i < radios.size(); i++){
		var radio = radios.get(i);
		if (radio.checked) {
			var paneNameArray = this._radioPaneMap.get( radio );
			_setPanelDisplay(paneNameArray, "block");
		}
	}
}

/***************************************************************************************
 * SelectClosablePanes
 ***************************************************************************************/

function SelectClosablePanes( ctrl ){
	var _optionPaneMap = new Map();
	var _paneNameSet = new Set();
	var _ctrl = ctrl;
	
	var _add = function(optionTag, mappedPaneNameArray) {
		if (! optionTag) {
			alert(optionId + " was not found");
		}
		_optionPaneMap.put(optionTag, mappedPaneNameArray);
		for (i = 0; i < mappedPaneNameArray.length; i++) {
			var panelName = mappedPaneNameArray[i];
			_paneNameSet.add( panelName );
		}
	}
	
	this.add = function(optionId, mappedPaneNameArray) {
		var optionTag = xBrowser.getTag(optionId);
		_add(optionTag, mappedPaneNameArray);
	}
	
	this.addByValue = function(optionValue, mappedPaneNameArray) {
		for(i = 0; i < _ctrl.options.length; i++ ) {
			var option = _ctrl.options[i];
			if (option.value == optionValue) {
				_add(option, mappedPaneNameArray);
				return;
			}
		}
		alert("option not found for " + optionValue);
	}
	
	var _refresh = function() {
		_setPanelDisplay(_paneNameSet.toArray(), "none");
		//
		var selIndex = _ctrl.selectedIndex;
		var option = _ctrl.options[ selIndex ];
		var paneNameArray = _optionPaneMap.get( option );
		_setPanelDisplay(paneNameArray, "block");
	}

	this.refresh = _refresh;
	
	this.doOnChange = function( e ) {
		_refresh();
	}
	
	xBrowser.prepareEventTargetInterface( ctrl );
	ctrl.addEventListener("change", this.doOnChange, true);
}


/***************************************************************************************
 * KeyLimitImpl
 * clientboolean isAccepable(event)ĂPredicate݂ȃIuWFNg
 ***************************************************************************************/
var _count = 0; 
 
function KeyLimitImpl(ctrl, client, handlingControlKey) {
	_count = _count + 1;
	this._index = _count;

	var _client = client;
	var _handlingControlKey = handlingControlKey;
	//
	var _acceptOnKeyPress = false;
	
	this.ctrlKeyDown = function( e ) {
		var keyCode = xBrowser.getKeyCode(e);
		if (_handlingControlKey) {
			if (keyUtils.isControlKeyCode(keyCode)) {
				_acceptOnKeyPress = true;
				return true;
			} else if (_isAcceptableShortCut(e)){
				_acceptOnKeyPress = true;
				return true;
			}
		}
		_acceptOnKeyPress = _client.isAccepable(e);
		return true;
	}

	//Cxg̃ANZXp
	var _isAcceptableShortCut = function(e) {
		if (! e.ctrlKey) 
			return false;
		var keyCode = xBrowser.getKeyCode(e);
		switch (keyCode) {
			case KEY_CODE_A.code: //select all
			case KEY_CODE_C.code: //copy
			case KEY_CODE_V.code: //paste
			case KEY_CODE_X.code: //cut
			case KEY_CODE_Y.code: //redo
			case KEY_CODE_Z.code: //undo
				return true;
			default:
				return false;
		}
	}
	
	//ÕANZXp
	this.isAcceptableShortCut = _isAcceptableShortCut;

	this.ctrlKeyPress = function( e ){
		if (! _acceptOnKeyPress)
			xBrowser.exitEvent(e);
		return _acceptOnKeyPress;
	}
	
	xBrowser.prepareEventTargetInterface( ctrl );
	ctrl.addEventListener("keydown", this.ctrlKeyDown, true);
	ctrl.addEventListener("keypress", this.ctrlKeyPress, true);
}


/***************************************************************************************
 * KeyLimit
 * acceptable͕̔z񂩕
 ***************************************************************************************/
function KeyLimit( ctrl, acceptable, refused ) {
	this._acceptable = acceptable;
	this._refused = refused;
	//
	this.isAccepable = function(e) {
		if (this._refused)
			return ! this.isIncludedInAcceptable(e);
		else
			return this.isIncludedInAcceptable(e);
	}
	
	this.isIncludedInAcceptable = function( e ) {
		var charCode = keyUtils.toCharCode( e );
		var c = String.fromCharCode(charCode);
		if (isDefined(this._acceptable.indexOf))
			return this._acceptable.indexOf(c) > -1;
		else
			return stringUtils.includeChar(c, this._acceptable);
	}
	
	new KeyLimitImpl(ctrl, this, true);
}

/***************************************************************************************
 * NumberKeyLimit
 * clientString getSourceText()ĂIuWFNg
 ***************************************************************************************/
function NumberKeyLimit( ctrl, minusEnabled, plusEnabled, defaultValue, 
	maxIntegerLength, maxDecimalLength, client) {
	this._ctrl = ctrl;
	this._acceptableChars = "0123456789";
	if ((minusEnabled == null) || minusEnabled) //ftHgtrue
		this._acceptableChars = this._acceptableChars + "-";
	if ((plusEnabled == null) || plusEnabled) //ftHgtrue
		this._acceptableChars = this._acceptableChars + "+";
	if ((maxDecimalLength == null) || (maxDecimalLength > 0))
		this._acceptableChars = this._acceptableChars + ".";
	
	this._defaultValue = (defaultValue != null) ? defaultValue : 0;
	this._maxIntegerLength = (maxIntegerLength != null) ? maxIntegerLength : 5; //ftHgnull
	this._maxDecimalLength = (maxDecimalLength != null) ? maxDecimalLength : 5; //ftHgnull
	this._client = client;
	//
	this.getLength = function( str ) {
		var result = str.length;
		if (str.indexOf("-") > -1)
			result--;
		if (str.indexOf("+") > -1)
			result--;
		if (str.indexOf(".") > -1)
			result--;
		return result;
	}
	
	this.getSourceText = function() {
		return (this._client != null) ? this._client.getSourceText() : this._ctrl.value;
	}
	
	this.simulate = function( e ) {
		var charCode = keyUtils.toCharCode( e );
		var keyCode = xBrowser.getKeyCode(e);
		var c = String.fromCharCode(charCode);
		var str = this.getSourceText();
		//
		var head;
		var middle;
		var tail;
		if (xBrowser.ie) {
			//JScript̃C^tF[X߂ǂ
			var originalRange = this._ctrl.document.selection.createRange();
			//
			var rangeMiddle = originalRange.duplicate();
			rangeMiddle.setEndPoint("StartToStart", originalRange);
			rangeMiddle.setEndPoint("EndToEnd", originalRange);
			middle = rangeMiddle.text;
			//
			var headRange = originalRange.duplicate();
			headRange.moveStart("sentence", -1);
			headRange.setEndPoint("EndToStart", rangeMiddle);
			head = headRange.text;
			//
			var tailRange = originalRange.duplicate();
			tailRange.setEndPoint("StartToEnd", rangeMiddle);
			tailRange.moveEnd("sentence", 1);
			tail = tailRange.text;
		} else {
			head = str.slice(0, this._ctrl.selectionStart);
			middle = str.slice(this._ctrl.selectionStart, this._ctrl.selectionEnd);
			tail = str.slice(this._ctrl.selectionEnd, str.length);
		}
		
		if (this._acceptableChars.indexOf(c) > -1 ) {
			middle = c;
		} else if (keyUtils.isControlKeyCode(keyCode)) {
			if (this._ctrl.selectionEnd == this._ctrl.selectionStart) {
				switch (keyCode) {
					case KEY_CODE_BACK_SPACE.code: 
						head = head.slice(0, head.length -1);
						middle = "";
						break;
					case KEY_CODE_DELETE.code: 
						tail = tail.slice(1, tail.length -1);
						middle = "";
						break;
				}
			} else {
				switch (keyCode) {
					case KEY_CODE_BACK_SPACE.code: 
					case KEY_CODE_DELETE.code: 
						middle = "";
				}
			}
		} else {
			return null;
		}
		return head + middle + tail;
	}
	
	this.checkDuplicate = function(str, c) {
		var indexFirst = str.indexOf(c);
		if (indexFirst < 0)
			return true;
		var indexLast = str.lastIndexOf(c);
		return indexFirst == indexLast;
	}
	
	this.checkDuplicateAndTop = function(str, c) {
		var indexFirst = str.indexOf(c);
		if (indexFirst < 0)
			return true;
		if (indexFirst > 0)
			return false;
		var indexLast = str.lastIndexOf(c);
		return indexFirst == indexLast;
	}
	
	this.checkMaxIntegerLength = function(str) {
		if (this._maxIntegerLength == null)
			return true;
		var indexOfDecimalPoint = str.indexOf(".");
		var integerStr = (indexOfDecimalPoint < 0) ? 
			str : str.slice(0, indexOfDecimalPoint);
		
		var simulatedLength = this.getLength(integerStr);
		var result = simulatedLength <= this._maxIntegerLength;
		return result;
	}
	
	this.checkMaxDecimalLength = function(str) {
		if (this._maxDecimalLength == null)
			return true;
		var indexOfDecimalPoint = str.indexOf(".");
		if (indexOfDecimalPoint < 0)
			return true;
		var decimalStr = str.slice(indexOfDecimalPoint + 1);
		return decimalStr.length <= this._maxDecimalLength;
	}
	
	this.isAccepable = function(e) {
		if (this.limitImpl.isAcceptableShortCut(e) )
			return true;
		var simulatedStr = this.simulate( e );
		if (simulatedStr == null)
			return false;
		if (! this.checkDuplicateAndTop(simulatedStr, "+"))
			return false;
		if (! this.checkDuplicateAndTop(simulatedStr, "-"))
			return false;
		if (! this.checkDuplicate(simulatedStr, "."))
			return false;
		if (! this.checkMaxIntegerLength(simulatedStr))
			return false;
		if (! this.checkMaxDecimalLength(simulatedStr))
			return false;
		return true;
	}
	
	this.limitImpl = new KeyLimitImpl(this._ctrl, this, false);
	
}

/***************************************************************************************
 * CurrencyLimit
 ***************************************************************************************/
function CurrencyLimit(ctrl, minusEnabled, plusEnabled, defaultValue, 
	maxIntegerLength, maxDecimalLength, separator) {
	//
	this._ctrl = ctrl;
	this._separator = (separator != null) ? separator : ",";
	this._numberLimit = 
		new NumberKeyLimit(ctrl, minusEnabled, plusEnabled, defaultValue, 
			maxIntegerLength, (maxDecimalLength != null) ? maxDecimalLength : 0, this);
	
	this.getSourceText = function() {
		var str = this._ctrl.value;
		var result = "";
		for (var i = 0; i < str.length; i++) {
			if (str.charAt(i) != this._separator)
				result = result + str.charAt(i);
		}
		return result;
	}
	
	
	
}


-->