/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import org.asyrinx.brownie.core.chars.CharactersExpressionParser;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.validator.prop.AbstractStringField;
import org.asyrinx.brownie.validator.prop.AcceptableCharacters;

public class StringFieldCharsExp
extends AbstractStringField {
    private AcceptableCharacters acceptedValidator = null;
    private AcceptableCharacters refusedValidator = null;
    private String accepted = null;
    private String refused = null;
    private CharactersExpressionParser characterSetExpressionParser = null;

    public StringFieldCharsExp(String propertyName, String displayName, boolean required, int size) {
        super(propertyName, displayName, required, size);
    }

    protected void prepareValidators() {
        this.addValidator(this.getAcceptedValidator());
        this.addValidator(this.getRefusedValidator());
    }

    private AcceptableCharacters createAcceptable(String exp, boolean refused) {
        if (StringUtils.isEmpty((String)exp)) {
            return null;
        }
        return new AcceptableCharacters(this.getPropertyName(), this.getDisplayName(), this.characterSetExpressionParser.parseToComposite(exp), refused);
    }

    public AcceptableCharacters getAcceptedValidator() {
        if (this.acceptedValidator == null) {
            this.acceptedValidator = this.createAcceptable(this.getAccepted(), false);
        }
        return this.acceptedValidator;
    }

    public AcceptableCharacters getRefusedValidator() {
        if (this.refusedValidator == null) {
            this.refusedValidator = this.createAcceptable(this.getRefused(), true);
        }
        return this.refusedValidator;
    }

    public String getAccepted() {
        return this.accepted;
    }

    public void setAccepted(String accepted) {
        this.accepted = accepted;
    }

    public String getRefused() {
        return this.refused;
    }

    public void setRefused(String refused) {
        this.refused = refused;
    }

    public CharactersExpressionParser getCharacterSetExpressionParser() {
        return this.characterSetExpressionParser;
    }

    public void setCharacterSetExpressionParser(CharactersExpressionParser characterSetExpressionParser) {
        this.characterSetExpressionParser = characterSetExpressionParser;
    }
}

