/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidatorRuntimeException;
import org.asyrinx.brownie.validator.prop.AbstractPropertyValidator;

public class MaxByteLength
extends AbstractPropertyValidator {
    private final int maxLength;
    private String charset = null;

    public MaxByteLength(String propertyName, String displayName, int maxLength) {
        super(propertyName, displayName);
        this.maxLength = maxLength;
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (propertyValue == null) {
            return;
        }
        try {
            int length = StringUtils.getByteSize((String)propertyValue, this.getCharset());
            if (length > this.maxLength) {
                this.addError(context);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ValidatorRuntimeException(e);
        }
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("maxLength", new Integer(this.getMaxLength()));
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public int getMaxLength() {
        return this.maxLength;
    }
}

