/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.prop;

import java.util.Map;
import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.prop.AbstractPropertyValidator;

public class AcceptableCharacters
extends AbstractPropertyValidator {
    private final Characters characterSet;
    private final boolean refuse;

    public AcceptableCharacters(String propertyName, String displayName, Characters characterSet) {
        this(propertyName, displayName, characterSet, false);
    }

    public void evaluate(ValidationContext context, Object obj, Object propertyValue) {
        if (!this.checkAcceptable((String)propertyValue)) {
            this.addError(context);
        }
    }

    public AcceptableCharacters(String propertyName, String displayName, Characters characterSet, boolean refuse) {
        super(propertyName, displayName);
        this.characterSet = characterSet;
        this.refuse = refuse;
    }

    protected String getMessageKey() {
        return String.valueOf(super.getMessageKey()) + (this.refuse ? ".refuse" : ".accept");
    }

    protected void prepareParameters(Map parameters) {
        super.prepareParameters(parameters);
        parameters.put("acceptable", this.getCharacters().getName());
    }

    private boolean checkAcceptable(String propValue) {
        if (propValue == null) {
            return true;
        }
        int i = 0;
        while (i < propValue.length()) {
            if (!this.checkAcceptable(propValue.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkAcceptable(char c) {
        return !(this.refuse ? this.characterSet.contains(c) : !this.characterSet.contains(c));
    }

    public Characters getCharacters() {
        return this.characterSet;
    }

    public boolean isRefuse() {
        return this.refuse;
    }
}

