/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.validator.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.ParameterizedMessageResource;
import org.asyrinx.brownie.core.resource.impl.ParameterizedMessageResourceImpl;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.MessageLevel;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.impl.MessageImpl;

public class ValidationContextImpl
implements ValidationContext {
    private MessageResource resource = null;
    private List messages = null;
    private ParameterizedMessageResource formatResource = null;
    private MessageLevel matterLevel = MessageLevel.ERROR;

    public ValidationContext createSubContext() {
        ValidationContextImpl result = new ValidationContextImpl();
        result.setResource(this.getResource());
        result.setMatterLevel(this.getMatterLevel());
        return result;
    }

    public MessageResource getResource() {
        return this.resource;
    }

    public void setResource(MessageResource resource) {
        this.resource = resource;
    }

    public void add(Message message) {
        if (this.messages == null) {
            this.messages = new ArrayList();
        }
        this.messages.add(message);
    }

    public Message addMessage(String text, MessageLevel type) {
        MessageImpl message = new MessageImpl(text, type);
        this.add(message);
        return message;
    }

    protected String format(String key, Map parameters) {
        if (this.formatResource == null) {
            this.formatResource = new ParameterizedMessageResourceImpl(this.getResource());
        }
        return this.formatResource.getMessage(key, parameters);
    }

    public Message addMessageByKey(String key, MessageLevel type, Map parameters) {
        String msg = this.format(key, parameters);
        return this.addMessage(msg, type);
    }

    public Message addFatal(String key, Map parameters) {
        return this.addMessageByKey(key, MessageLevel.FATAL, parameters);
    }

    public Message addError(String key, Map parameters) {
        return this.addMessageByKey(key, MessageLevel.ERROR, parameters);
    }

    public Message addWarn(String key, Map parameters) {
        return this.addMessageByKey(key, MessageLevel.WARN, parameters);
    }

    public Message addInfo(String key, Map parameters) {
        return this.addMessageByKey(key, MessageLevel.INFO, parameters);
    }

    public Message addDebug(String key, Map parameters) {
        return this.addMessageByKey(key, MessageLevel.DEBUG, parameters);
    }

    public Message addMessageByKey(String key, MessageLevel type) {
        return this.addMessageByKey(key, type, Collections.EMPTY_MAP);
    }

    public Message addFatal(String key) {
        return this.addFatal(key, Collections.EMPTY_MAP);
    }

    public Message addError(String key) {
        return this.addError(key, Collections.EMPTY_MAP);
    }

    public Message addWarn(String key) {
        return this.addWarn(key, Collections.EMPTY_MAP);
    }

    public Message addInfo(String key) {
        return this.addInfo(key, Collections.EMPTY_MAP);
    }

    public Message addDebug(String key) {
        return this.addDebug(key, Collections.EMPTY_MAP);
    }

    public void addMessages(ValidationContext subContext) {
        List messages = subContext.getMessages();
        Iterator i = messages.iterator();
        while (i.hasNext()) {
            this.add((Message)i.next());
        }
    }

    public boolean isEmptyMessage() {
        return this.messages == null ? true : this.messages.isEmpty();
    }

    public List getMessages() {
        return this.messages != null ? this.messages : Collections.EMPTY_LIST;
    }

    public List getMessages(final String propertyName) {
        return this.getMessages(new Predicate(){

            public boolean evaluate(Object object) {
                Message message = (Message)object;
                return message.containsProperty(propertyName);
            }
        });
    }

    public List getMessages(final MessageLevel level) {
        return this.getMessages(new Predicate(){

            public boolean evaluate(Object object) {
                Message message = (Message)object;
                return message.getLevel().isGreaterEqual(level);
            }
        });
    }

    public List getMessages(Predicate predicate) {
        if (this.messages == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Message> result = new ArrayList<Message>();
        Iterator i = this.messages.iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            if (!predicate.evaluate((Object)message)) continue;
            result.add(message);
        }
        return result;
    }

    public Set getProperties() {
        HashSet result = new HashSet();
        Iterator i = this.messages.iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            Iterator j = message.iteratorProperties();
            while (j.hasNext()) {
                result.add(j.next());
            }
        }
        return result;
    }

    public MessageLevel getMatterLevel() {
        return this.matterLevel;
    }

    public void setMatterLevel(MessageLevel matterLevel) {
        this.matterLevel = matterLevel;
    }

    public List getMatters() {
        return this.getMessages(this.getMatterLevel());
    }

    public String buildText(String delim) {
        StringBuffer result = new StringBuffer();
        Iterator i = this.getMessages().iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            result.append("[").append(message.getLevel().getName()).append("] ");
            result.append(message.getText());
            if (!i.hasNext()) continue;
            result.append(delim);
        }
        return result.toString();
    }
}

