/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.valid;

import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.ValidatorException;
import org.asyrinx.brownie.tapestry.valid.ScriptValidator;
import org.asyrinx.brownie.validator.ValidationContext;
import org.asyrinx.brownie.validator.ValidationContextFactory;
import org.asyrinx.brownie.validator.prop.AcceptableCharacters;
import org.asyrinx.brownie.validator.prop.StringField;

public class StringFieldValidator
extends ScriptValidator {
    private final StringField stringField;
    private String acceptedCharacters = null;
    private String acceptedCaption = null;
    private String refusedCharacters = null;
    private String refusedCaption = null;
    private ValidationContextFactory contextFactory = null;
    private boolean checkOnBlur = false;
    private boolean checkOnSubmit = true;

    public StringFieldValidator(StringField stringField) {
        super("/org/asyrinx/brownie/tapestry/valid/StringFieldValidator.script");
        this.stringField = stringField;
    }

    public Object toObject(IFormComponent field, String input) throws ValidatorException {
        ValidationContext context = this.createContext();
        this.stringField.evaluate(context, null, input);
        if (!context.getMatters().isEmpty()) {
            throw new ValidatorException(context.buildText(","));
        }
        return super.toObject(field, input);
    }

    public boolean isRequired() {
        return this.stringField.isRequired();
    }

    public int getMaxLength() {
        return this.stringField.getMaxLength();
    }

    public String getAccepted() {
        return this.stringField.getAccepted();
    }

    public String getAcceptedCharacters() {
        if (this.acceptedCharacters == null) {
            AcceptableCharacters v = this.stringField.getAcceptedValidator();
            this.acceptedCharacters = v == null ? "" : v.getCharacters().expandToString();
        }
        return this.acceptedCharacters;
    }

    public String getAcceptedCaption() {
        if (this.acceptedCaption == null) {
            AcceptableCharacters v = this.stringField.getAcceptedValidator();
            this.acceptedCaption = v == null ? "" : v.getCharacters().getName();
        }
        return this.acceptedCaption;
    }

    public String getRefused() {
        return this.stringField.getRefused();
    }

    public String getRefusedString() {
        if (this.refusedCharacters == null) {
            AcceptableCharacters v = this.stringField.getRefusedValidator();
            this.refusedCharacters = v == null ? "" : v.getCharacters().expandToString();
        }
        return this.refusedCharacters;
    }

    public String getRefusedCaption() {
        if (this.refusedCaption == null) {
            AcceptableCharacters v = this.stringField.getRefusedValidator();
            this.refusedCaption = v == null ? "" : v.getCharacters().getName();
        }
        return this.refusedCaption;
    }

    public String getRegExp() {
        return this.stringField.getRegExp();
    }

    protected ValidationContext createContext() {
        return this.getContextFactory().createContext();
    }

    public ValidationContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(ValidationContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public boolean isCheckOnBlur() {
        return this.checkOnBlur;
    }

    public void setCheckOnBlur(boolean checkOnBlur) {
        this.checkOnBlur = checkOnBlur;
    }

    public boolean isCheckOnSubmit() {
        return this.checkOnSubmit;
    }

    public void setCheckOnSubmit(boolean checkOnSubmit) {
        this.checkOnSubmit = checkOnSubmit;
    }
}

