/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IAsset;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.core.lang.StringUtils;

public class BindingUtils {
    private static final Log log;
    public static final ComponentParameterFilter ALL;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.asyrinx.brownie.tapestry.util.BindingUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
        ALL = new ComponentParameterFilter(){

            public boolean filter(IComponent component, IRequestCycle cycle, String name, String attribute) {
                return true;
            }

            public void put(IComponent component, IRequestCycle cycle, Map dest, String name, String attribute) {
                dest.put(name, attribute);
            }
        };
    }

    public static void renderInformalParametersFilteredTail(IComponent component, IMarkupWriter writer, IRequestCycle cycle, String tail) {
        Map filteredParams = BindingUtils.getInformalParameters(component, cycle, new TailFilter(tail));
        log.debug((Object)("renderInformalParametersFilteredTail tail=" + tail + "  filteredParams = " + filteredParams));
        BindingUtils.renderParameters(writer, filteredParams);
    }

    public static void renderInformalParameters(IComponent component, IMarkupWriter writer, IRequestCycle cycle) {
        Map filteredParams = BindingUtils.getInformalParameters(component, cycle, ALL);
        BindingUtils.renderParameters(writer, filteredParams);
    }

    private static void renderParameters(IMarkupWriter writer, Map parameters) {
        Iterator i = parameters.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = String.valueOf(entry.getKey());
            String attribute = String.valueOf(entry.getValue());
            writer.attribute(name, attribute);
        }
    }

    public static Map getComponentParameters(IComponent component, IRequestCycle cycle) {
        return BindingUtils.getInformalParameters(component, cycle, ALL);
    }

    public static String getInformalParameter(IComponent component, String parameterName) {
        IBinding value = component.getBinding(parameterName);
        return value == null ? null : value.getString();
    }

    public static Map getInformalParameters(IComponent component, IRequestCycle cycle, ComponentParameterFilter filter) {
        if (component.getBindings() == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap result = new HashMap();
        Iterator i = component.getBindings().entrySet().iterator();
        while (i.hasNext()) {
            String attribute;
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            IBinding binding = (IBinding)entry.getValue();
            Object value = binding.getObject();
            if (value == null) continue;
            if (value instanceof IAsset) {
                IAsset asset = (IAsset)value;
                attribute = asset.buildURL(cycle);
            } else {
                attribute = value.toString();
            }
            if (!filter.filter(component, cycle, name, attribute)) continue;
            filter.put(component, cycle, result, name, attribute);
        }
        return result;
    }

    interface ComponentParameterFilter {
        public boolean filter(IComponent var1, IRequestCycle var2, String var3, String var4);

        public void put(IComponent var1, IRequestCycle var2, Map var3, String var4, String var5);
    }

    public static class TailFilter
    implements ComponentParameterFilter {
        protected final String tail;

        public TailFilter(String tail) {
            this.tail = tail;
        }

        public boolean filter(IComponent component, IRequestCycle cycle, String name, String attribute) {
            return name.endsWith(this.tail);
        }

        public void put(IComponent component, IRequestCycle cycle, Map dest, String name, String attribute) {
            String key = StringUtils.left((String)name, (int)(name.length() - this.tail.length()));
            dest.put(key, attribute);
        }
    }
}

