/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.script;

import java.util.HashMap;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.IScript;
import org.apache.tapestry.IScriptProcessor;
import org.apache.tapestry.html.Body;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptUtils;

public class ScriptWriter {
    private final IScriptUser user;
    private final String scriptName;
    private ScriptUsage usage = ScriptUsage.EVERYTIME;
    private IScript script = null;

    public ScriptWriter(IScriptUser user, String scriptName) {
        this.user = user;
        this.scriptName = scriptName;
    }

    public void checkBeforeWrite(IRequestCycle cycle) {
        Body body = Body.get((IRequestCycle)cycle);
        if (body == null) {
            throw new ApplicationRuntimeException("must-be-contained-by-body", (Object)this.user, null, null);
        }
    }

    public void execute(IRequestCycle cycle) {
        this.checkBeforeWrite(cycle);
        if (!this.usage.canWrite(this.user, cycle)) {
            return;
        }
        HashMap symbols = new HashMap();
        this.user.prepareScriptSymbols(symbols, cycle);
        Body body = Body.get((IRequestCycle)cycle);
        this.loadScript().execute(cycle, (IScriptProcessor)body, symbols);
    }

    protected IScript loadScript() {
        if (this.script == null) {
            this.script = ScriptUtils.loadScript(this.user, this.scriptName);
        }
        return this.script;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public IScriptUser getUser() {
        return this.user;
    }

    public ScriptUsage getUsage() {
        return this.usage;
    }

    public void setUsage(ScriptUsage usage) {
        this.usage = usage;
    }
}

