/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.valid;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.asyrinx.brownie.tapestry.script.IScriptUser;
import org.asyrinx.brownie.tapestry.script.ScriptUsage;
import org.asyrinx.brownie.tapestry.script.ScriptWriter;
import org.asyrinx.brownie.validator.Message;
import org.asyrinx.brownie.validator.ValidationContext;

public abstract class DisplayValidationContext
extends AbstractComponent
implements IScriptUser {
    private final ScriptWriter scriptWriter = new ScriptWriter(this, "DisplayValidationContext.script");

    public DisplayValidationContext() {
        this.scriptWriter.setUsage(ScriptUsage.ONCE_BY_OBJECT);
    }

    public abstract ValidationContext getContext();

    public abstract boolean isAlert();

    public void prepareScriptSymbols(Map symbols, IRequestCycle cycle) {
        symbols.put("messages", this.getContextMessages());
    }

    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        if (this.isAlert()) {
            this.scriptWriter.execute(cycle);
        } else {
            this.renderMessages(writer, cycle);
        }
    }

    public List getContextMessages() {
        ValidationContext context = this.getContext();
        if (context == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator i = context.getMessages().iterator();
        while (i.hasNext()) {
            Message message = (Message)i.next();
            result.add(message.getText());
        }
        return result;
    }

    private void renderMessages(IMarkupWriter writer, IRequestCycle cycle) {
        Iterator i = this.getContextMessages().iterator();
        while (i.hasNext()) {
            String msgText = (String)i.next();
            writer.print(msgText);
            writer.beginEmpty("br");
            writer.closeTag();
            writer.println();
        }
    }
}

