/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.tapestry.components.form;

import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.ApplicationRuntimeException;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;
import org.apache.tapestry.form.Form;
import org.apache.tapestry.form.IFormComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.tapestry.util.BindingUtils;

public abstract class Label
extends AbstractComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        if (cycle.isRewinding()) {
            return;
        }
        IFormComponent field = this.getField();
        IForm form = Form.get((IRequestCycle)cycle);
        if (form == null) {
            String msg = Tapestry.getMessage((String)"FieldLabel.must-be-contained-by-form");
            throw new ApplicationRuntimeException(msg, (Object)this, null, null);
        }
        IValidationDelegate delegate = form.getDelegate();
        if (delegate == null) {
            String msg = Tapestry.format((String)"FieldLabel.no-delegate", (Object)this.getExtendedId(), (Object)form.getExtendedId());
            throw new ApplicationRuntimeException(msg, (Object)this, null, null);
        }
        delegate.writeLabelPrefix(field, writer, cycle);
        if (this.getBodyCount() > 0) {
            this.renderBody(writer, cycle);
        } else {
            String displayName = this.getDisplayName(field);
            if (!StringUtils.isEmpty((String)displayName)) {
                if (this.getRaw()) {
                    writer.printRaw(displayName);
                } else {
                    writer.print(displayName);
                }
            }
        }
        delegate.writeLabelSuffix(field, writer, cycle);
    }

    private String getDisplayName(IFormComponent field) {
        String displayName = this.getDisplayName();
        if (displayName != null) {
            return displayName;
        }
        if (field == null) {
            throw Tapestry.createRequiredParameterException((IComponent)this, (String)"field");
        }
        displayName = field.getDisplayName();
        if (displayName != null) {
            return displayName;
        }
        displayName = BindingUtils.getInformalParameter((IComponent)field, "displayName");
        if (displayName != null) {
            return displayName;
        }
        return null;
    }

    public abstract String getDisplayName();

    public abstract IFormComponent getField();

    public abstract boolean getRaw();
}

