/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.seasar.container.factory;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.seasar.container.factory.BrownieXmlS2ContainerBuilder;
import org.seasar.framework.container.ExtensionNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerBuilder;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.PropertiesUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;

public final class BrownieS2ContainerFactory {
    private static Properties builderProps_ = new Properties();
    private static Map defaultBuilders = new HashMap();
    private static S2ContainerBuilder defaultBuilder_ = new BrownieXmlS2ContainerBuilder();
    private final Map builders = new HashMap();
    private static final Map factories;

    static {
        if (ResourceUtil.isExist((String)"s2containerbuilder.properties")) {
            PropertiesUtil.load((Properties)builderProps_, (InputStream)ResourceUtil.getResourceAsStream((String)"s2containerbuilder.properties"));
        }
        defaultBuilders.put("xml", defaultBuilder_);
        defaultBuilders.put("dicon", defaultBuilder_);
        factories = new HashMap();
    }

    private static S2ContainerBuilder getDefaultBuilder(String ext) {
        S2ContainerBuilder builder = (S2ContainerBuilder)defaultBuilders.get(ext);
        if (builder != null) {
            return builder;
        }
        Map map = defaultBuilders;
        synchronized (map) {
            builder = (S2ContainerBuilder)defaultBuilders.get(ext);
            if (builder != null) {
                return builder;
            }
            String className = builderProps_.getProperty(ext);
            if (className != null) {
                builder = (S2ContainerBuilder)ClassUtil.newInstance((String)className);
                defaultBuilders.put(ext, builder);
            } else {
                builder = defaultBuilder_;
            }
        }
        return builder;
    }

    private BrownieS2ContainerFactory() {
    }

    private BrownieS2ContainerFactory(String baseDirs) {
        this();
        StreamFactoryFacade sff = StreamFactoryFacade.newFacade(baseDirs);
        sff.setDefaultLevel("info");
        BrownieXmlS2ContainerBuilder diconBuilder = new BrownieXmlS2ContainerBuilder(sff);
        this.builders.put("xml", diconBuilder);
        this.builders.put("dicon", diconBuilder);
    }

    private S2ContainerBuilder getBuilder(String ext) {
        S2ContainerBuilder builder = (S2ContainerBuilder)this.builders.get(ext);
        return builder != null ? builder : BrownieS2ContainerFactory.getDefaultBuilder(ext);
    }

    private static BrownieS2ContainerFactory getFactory(String baseDirs) {
        BrownieS2ContainerFactory factory = (BrownieS2ContainerFactory)factories.get(Thread.currentThread());
        if (factory == null) {
            factory = StringUtil.isEmpty((String)baseDirs) ? new BrownieS2ContainerFactory() : new BrownieS2ContainerFactory(baseDirs);
        }
        factories.put(Thread.currentThread(), factory);
        return factory;
    }

    protected S2Container doCreate(String path) {
        String ext = ResourceUtil.getExtension((String)path);
        if (ext == null) {
            throw new ExtensionNotFoundRuntimeException(path);
        }
        S2ContainerBuilder builder = this.getBuilder(ext);
        return builder.build(path);
    }

    public static S2Container create(String path) {
        return BrownieS2ContainerFactory.create(path, null);
    }

    public static S2Container create(String path, String baseDirs) {
        BrownieS2ContainerFactory factory = BrownieS2ContainerFactory.getFactory(baseDirs);
        return factory.doCreate(path);
    }
}

