/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.xml.digester;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import org.apache.commons.digester.Digester;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.asyrinx.brownie.core.xml.digester.ConstructorRule;
import org.asyrinx.brownie.core.xml.digester.DigesterException;
import org.asyrinx.brownie.core.xml.digester.PopRule;
import org.asyrinx.brownie.core.xml.digester.PushPropertyRule;
import org.asyrinx.brownie.core.xml.digester.SetBodyToPropertyRule;
import org.asyrinx.brownie.core.xml.digester.SetPropertiesWithOptionsRule;
import org.asyrinx.brownie.core.xml.digester.SetToMapRule;
import org.asyrinx.brownie.core.xml.digester.StackSetPropertyRule;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class AsyrinxDigester
extends Digester {
    public static final String ATTRIBUTE_CLASS_DEFAULT = "class";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private Stack elementNames = new Stack();

    public AsyrinxDigester() {
    }

    public AsyrinxDigester(SAXParser parser) {
        super(parser);
    }

    public AsyrinxDigester(XMLReader reader) {
        super(reader);
    }

    private String getLastElementName() {
        StringBuffer result = new StringBuffer();
        Iterator i = this.elementNames.iterator();
        while (i.hasNext()) {
            Tag tag = (Tag)i.next();
            result.append(tag.qName);
            if (i.hasNext()) {
                result.append("/");
                continue;
            }
            result.append(" ");
            result.append(this.toString(tag.list));
        }
        return result.toString();
    }

    private String toString(Attributes attributes) {
        StringBuffer result = new StringBuffer();
        int j = 0;
        while (j < attributes.getLength()) {
            result.append(String.valueOf(attributes.getQName(j)) + "=" + attributes.getValue(j));
            if (j < attributes.getLength() - 1) {
                result.append(" ");
            }
            ++j;
        }
        return result.toString();
    }

    public SAXException createSAXException(Exception e) {
        if (e instanceof DigesterException) {
            return (DigesterException)e;
        }
        return new DigesterException(this.getLastElementName(), (Throwable)e);
    }

    public SAXException createSAXException(Throwable e) {
        return new DigesterException(this.getLastElementName(), e);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        this.elementNames.push(new Tag(qName, list));
        super.startElement(namespaceURI, localName, qName, list);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.elementNames.pop();
        super.endElement(namespaceURI, localName, qName);
    }

    public Object parse(File file) throws IOException, SAXException {
        try {
            return super.parse(file);
        }
        catch (Throwable e) {
            throw this.createSAXException(e);
        }
    }

    public Object parse(InputSource input) throws IOException, SAXException {
        try {
            return super.parse(input);
        }
        catch (Throwable e) {
            throw this.createSAXException(e);
        }
    }

    public Object parse(InputStream input) throws IOException, SAXException {
        try {
            return super.parse(input);
        }
        catch (Throwable e) {
            throw this.createSAXException(e);
        }
    }

    public Object parse(Reader reader) throws IOException, SAXException {
        try {
            return super.parse(reader);
        }
        catch (Throwable e) {
            throw this.createSAXException(e);
        }
    }

    public Object parse(String uri) throws IOException, SAXException {
        try {
            return super.parse(uri);
        }
        catch (Throwable e) {
            throw this.createSAXException(e);
        }
    }

    public void addRoot(String pattern, Class clazz) {
        this.addRoot(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
    }

    public void addRoot(String pattern, String attributeName, Class clazz) {
        this.addObjectCreate(pattern, attributeName, clazz);
    }

    public void addRoot(String pattern, String className) {
        this.addRoot(pattern, className, ATTRIBUTE_CLASS_DEFAULT);
    }

    public void addRoot(String pattern, String className, String attributeName) {
        this.addObjectCreate(pattern, className, attributeName);
    }

    public void addAsProp(String pattern, String propertyName) {
        this.addRule(pattern, new StackSetPropertyRule(propertyName));
    }

    public void addProp(String pattern, Class clazz, String propertyName, boolean setProperties) {
        this.addObjectCreate(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
        this.addRule(pattern, new StackSetPropertyRule(propertyName));
        if (setProperties) {
            this.addSetProperties(pattern);
        }
    }

    public void addProp(String pattern, Class clazz, String propertyName) {
        this.addProp(pattern, clazz, propertyName, true);
    }

    public void addProps(String pattern, Class clazz, String addingMethodName) {
        this.addObjectCreate(pattern, ATTRIBUTE_CLASS_DEFAULT, clazz);
        this.addSetProperties(pattern);
        this.addSetNext(pattern, addingMethodName);
        this.addSetProperties(pattern);
    }

    public void addProps(String pattern, Class clazz) {
        this.addProps(pattern, clazz, "add");
    }

    public void addCallMethod(String pattern, String methodName, Class[] paramTypes, String[] paramName) {
        this.addCallMethod(pattern, methodName, paramTypes.length, paramTypes);
        int i = 0;
        while (i < paramName.length) {
            this.addCallParam(pattern, i, paramName[i]);
            ++i;
        }
    }

    public void addPushProperty(String patten, String propertyName) {
        this.addRule(patten, new PushPropertyRule(propertyName));
    }

    public void addPop(String patten) {
        this.addRule(patten, new PopRule());
    }

    public void addConstructor(String patten, Class clazz, Class[] paramTypes, String[] paramNames) {
        this.addRule(patten, new ConstructorRule(clazz, paramTypes, paramNames));
    }

    public void addProp(String pattern, Class clazz, Class[] paramTypes, String[] paramNames, String propertyName) {
        this.addProp(pattern, clazz, paramTypes, paramNames, propertyName, true);
    }

    public void addProp(String pattern, Class clazz, Class[] paramTypes, String[] paramNames, String propertyName, boolean setProperties) {
        this.addRule(pattern, new ConstructorRule(clazz, paramTypes, paramNames));
        this.addRule(pattern, new StackSetPropertyRule(propertyName));
        if (setProperties) {
            this.addSetProperties(pattern);
        }
    }

    public void addSetToMap(String pattern) {
        this.addRule(pattern, new SetToMapRule());
    }

    public void addBodyToProp(String pattern, String propertyName) {
        this.addRule(pattern, new SetBodyToPropertyRule(propertyName));
    }

    public void addSetProperties(String pattern) {
        this.addRule(pattern, new SetPropertiesWithOptionsRule());
    }

    public void addSetProperties(String pattern, String attributeName, String propertyName) {
        this.addRule(pattern, new SetPropertiesWithOptionsRule(attributeName, propertyName));
    }

    public void addSetProperties(String pattern, String[] attributeNames, String[] propertyNames) {
        this.addRule(pattern, new SetPropertiesWithOptionsRule(attributeNames, propertyNames));
    }

    public void addSetProperties(String pattern, String optionsPropertyName) {
        this.addRule(pattern, new SetPropertiesWithOptionsRule(optionsPropertyName));
    }

    public void addSetProperties(String pattern, String attributeName, String propertyName, String optionsPropertyName) {
        this.addRule(pattern, new SetPropertiesWithOptionsRule(attributeName, propertyName, optionsPropertyName));
    }

    public void addSetProperties(String pattern, String[] attributeNames, String[] propertyNames, String optionsPropertyName) {
        this.addRule(pattern, new SetPropertiesWithOptionsRule(attributeNames, propertyNames, optionsPropertyName));
    }

    class Tag {
        public final String qName;
        public final Attributes list;

        public Tag(String qName, Attributes list) {
            this.qName = qName;
            this.list = list;
        }
    }
}

