/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.text;

import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.asyrinx.brownie.core.lang.PropertyUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

public class MapMessageFormat
extends Format {
    private final List parameters;
    private final String pattern;
    private final String delimiterBegin;
    private final String delimiterEnd;

    public MapMessageFormat(String pattern) {
        this(pattern, "${", "}");
    }

    public MapMessageFormat(String pattern, String delimiterBegin, String delimiterEnd) {
        this.pattern = pattern;
        this.delimiterBegin = delimiterBegin;
        this.delimiterEnd = delimiterEnd;
        this.parameters = this.extractParameters();
    }

    public Object parseObject(String source, ParsePosition pos) {
        throw new UnsupportedOperationException();
    }

    protected List extractParameters() {
        int idxBegin;
        ArrayList<String> result = new ArrayList<String>();
        int idxEnd = -this.delimiterEnd.length();
        while ((idxBegin = this.pattern.indexOf(this.delimiterBegin, idxEnd + this.delimiterEnd.length())) > -1) {
            idxEnd = this.pattern.indexOf(this.delimiterEnd, idxBegin + this.delimiterBegin.length());
            if (idxEnd < 0) break;
            String parameter = this.pattern.substring(idxBegin + this.delimiterBegin.length(), idxEnd);
            result.add(parameter);
        }
        return result;
    }

    public final String format(Map attributes) {
        return this.format(attributes, new StringBuffer(), null).toString();
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        this.format(this.toMap(obj), toAppendTo);
        return toAppendTo;
    }

    protected Map toMap(Object obj) {
        if (obj == null) {
            return Collections.EMPTY_MAP;
        }
        if (obj instanceof Map) {
            return (Map)obj;
        }
        try {
            return PropertyUtils.describe((Object)obj);
        }
        catch (Exception e) {
            throw new UnsupportedClassRuntimeException("failed to get java.util.Map from " + obj);
        }
    }

    public void format(Map attributes, StringBuffer toAppendTo) {
        toAppendTo.append(this.getPattern());
        Iterator i = this.parameters.iterator();
        while (i.hasNext()) {
            String parameter = (String)i.next();
            String attribute = this.toStringAttribute(attributes.get(parameter), parameter);
            this.replaceAll(toAppendTo, parameter, attribute);
        }
    }

    protected String toStringAttribute(Object attribute, String parameter) {
        return attribute != null ? String.valueOf(attribute) : String.valueOf(this.delimiterBegin) + parameter + this.delimiterEnd;
    }

    protected void replaceAll(StringBuffer toAppendTo, String parameter, String attribute) {
        parameter = String.valueOf(this.delimiterBegin) + parameter + this.delimiterEnd;
        int parameterLength = parameter.length();
        int idx = toAppendTo.toString().indexOf(parameter);
        while (idx > -1) {
            toAppendTo.replace(idx, idx + parameterLength, attribute);
            idx = toAppendTo.toString().indexOf(parameter, idx + attribute.length());
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getDelimiterBegin() {
        return this.delimiterBegin;
    }

    public String getDelimiterEnd() {
        return this.delimiterEnd;
    }
}

