/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.text;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class EscapedStringSplitter {
    private final char delimiter;
    private final char escapeSymbol;

    public EscapedStringSplitter(char delimiter) {
        this(delimiter, '\\');
    }

    public EscapedStringSplitter(char delimiter, char escapeSymbol) {
        this.delimiter = delimiter;
        this.escapeSymbol = escapeSymbol;
    }

    public void execute(String value, List dest) {
        String parsed;
        if (value == null) {
            return;
        }
        if (StringUtils.isEmpty((String)value)) {
            dest.add("");
            return;
        }
        int idxLast = -1;
        int idxCurr = value.indexOf(this.delimiter, idxLast + 1);
        int idxEscaped = -1;
        while (idxCurr > -1) {
            if (this.isAfterEscapeSymbol(value, idxCurr)) {
                idxEscaped = idxCurr;
                idxCurr = value.indexOf(this.delimiter, idxEscaped + 1);
                continue;
            }
            parsed = this.buildParsed(value, idxLast, idxCurr, idxEscaped);
            dest.add(parsed);
            idxLast = idxCurr;
            idxCurr = value.indexOf(this.delimiter, idxLast + 1);
            idxEscaped = -1;
        }
        parsed = this.buildParsed(value, idxLast, value.length(), idxEscaped);
        dest.add(parsed);
    }

    private boolean isAfterEscapeSymbol(String value, int index) {
        if (index < 1) {
            return false;
        }
        return value.charAt(index - 1) == this.escapeSymbol;
    }

    private String buildParsed(String value, int idxLast, int idxCurr, int idxEscaped) {
        if (idxEscaped < 0) {
            return value.substring(idxLast + 1, idxCurr);
        }
        return String.valueOf(value.substring(idxLast + 1, idxEscaped - 1)) + value.substring(idxEscaped, idxCurr);
    }

    public String[] execute(String value) {
        ArrayList result = new ArrayList();
        this.execute(value, result);
        return result.toArray(new String[0]);
    }

    public char getEscapeSymbol() {
        return this.escapeSymbol;
    }
}

