/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.asyrinx.brownie.core.io.sf.StreamFactory;
import org.asyrinx.brownie.core.io.sf.StreamFactoryFacade;
import org.asyrinx.brownie.core.resource.MessageResource;
import org.asyrinx.brownie.core.resource.MessageResourceRuntimeException;

public class PropertiesMessageResource
implements MessageResource {
    protected final String filePath;
    protected final StreamFactory streamFactory;
    private Properties properties = null;

    public PropertiesMessageResource(String filePath) {
        this(filePath, StreamFactoryFacade.newFacade());
    }

    public PropertiesMessageResource(String filePath, StreamFactory streamFactory) {
        this.filePath = filePath;
        this.streamFactory = streamFactory;
    }

    public String getBase() {
        return this.filePath;
    }

    public String getMessage(String key) {
        String result;
        if (this.properties == null) {
            try {
                this.properties = this.createProperties();
            }
            catch (IOException e) {
                throw new MessageResourceRuntimeException("failed to load properties.", this.filePath, key, e);
            }
        }
        if ((result = this.properties.getProperty(key)) == null) {
            throw new MessageResourceRuntimeException("message not found.", this.filePath, key);
        }
        return result;
    }

    private Properties createProperties() throws IOException {
        Properties result = new Properties();
        InputStream stream = this.createStream();
        result.load(stream);
        return result;
    }

    private InputStream createStream() throws IOException {
        return this.streamFactory.newInput(this.filePath);
    }
}

