/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import java.util.HashMap;
import java.util.Map;

public class NumberUtils
extends org.apache.commons.lang.math.NumberUtils {
    private static final Map numberClassValues = NumberUtils.initNumberClassValues();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static int toInt(Object value, int defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double toDouble(Object value, double defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.parseDouble(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long toLong(Object value, long defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        try {
            return Long.parseLong(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean hasFractions(double value) {
        double f = NumberUtils.dropFractions(value);
        return Double.doubleToLongBits(value) != Double.doubleToLongBits(f);
    }

    public static double dropFractions(double value) {
        return value < 0.0 ? Math.ceil(value) : Math.floor(value);
    }

    public static Class getMinimumClass(double value) {
        Class<?> clazz;
        if (value == 0.0) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.Byte");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return clazz2;
        }
        if (NumberUtils.hasFractions(value)) {
            float floatValue = new Double(value = Math.abs(value)).floatValue();
            if ((double)floatValue == 0.0) {
                Class<?> clazz3 = class$1;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz3;
            }
            if (Double.compare(3.4028234663852886E38, value) >= 0 && Math.abs(value - (double)floatValue) < (double)1.4E-45f) {
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz4;
            }
        } else {
            if (-128.0 <= value && value <= 127.0) {
                Class<?> clazz5 = class$0;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$0 = Class.forName("java.lang.Byte");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz5;
            }
            if (-32768.0 <= value && value <= 32767.0) {
                Class<?> clazz6 = class$3;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$3 = Class.forName("java.lang.Short");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz6;
            }
            if (-2.147483648E9 <= value && value <= 2.147483647E9) {
                Class<?> clazz7 = class$4;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$4 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz7;
            }
            if (-9.223372036854776E18 <= value && value <= 9.223372036854776E18) {
                Class<?> clazz8 = class$5;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$5 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz8;
            }
            if (3.4028234663852886E38 >= (value = Math.abs(value))) {
                Class<?> clazz9 = class$2;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$2 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz9;
            }
        }
        if ((clazz = class$1) == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public static Number toMinimunNumberObject(double value) {
        return NumberUtils.toMinimunNumberObject(new Double(value));
    }

    public static Number toMinimunNumberObject(Number value) {
        Class numberClass = NumberUtils.getMinimumClass(value.doubleValue());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (numberClass == clazz) {
            return new Byte(value.byteValue());
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (numberClass == clazz2) {
            return new Short(value.shortValue());
        }
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (numberClass == clazz3) {
            return new Integer(value.intValue());
        }
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (numberClass == clazz4) {
            return new Long(value.longValue());
        }
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (numberClass == clazz5) {
            return new Float(value.floatValue());
        }
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (numberClass == clazz6) {
            return new Double(value.doubleValue());
        }
        return value;
    }

    private static Map initNumberClassValues() {
        HashMap result = new HashMap(){
            final Object defaultValue = new Integer(0);

            public Object get(Object key) {
                Object r = super.get(key);
                return r == null ? this.defaultValue : r;
            }
        };
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.put(clazz, new Integer(1));
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.put(clazz2, new Integer(2));
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.put(clazz3, new Integer(3));
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.put(clazz4, new Integer(4));
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.put(clazz5, new Integer(11));
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        result.put(clazz6, new Integer(12));
        return result;
    }

    private static Class maxClass(Class class1, Class class2) {
        Integer val1 = (Integer)numberClassValues.get(class1);
        Integer val2 = (Integer)numberClassValues.get(class2);
        return val1 > val2 ? class1 : class2;
    }

    public static Class getMaximunClassByClass(Number[] numbers) {
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class result = clazz;
        if (numbers != null) {
            int i = 0;
            while (i < numbers.length) {
                Number number = numbers[i];
                result = NumberUtils.maxClass(result, number.getClass());
                ++i;
            }
        }
        return result;
    }

    public static Class getMaximunClassByValue(Number[] numbers) {
        Class clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class result = clazz;
        if (numbers != null) {
            int i = 0;
            while (i < numbers.length) {
                Class numberClass = NumberUtils.getMinimumClass(numbers[i].doubleValue());
                result = NumberUtils.maxClass(result, numberClass);
                ++i;
            }
        }
        return result;
    }

    public static Number toNumber(Object value) {
        return value instanceof Number ? (Number)((Number)value) : (Number)NumberUtils.createNumber((String)String.valueOf(value));
    }

    public static boolean isNumber(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Number) {
            return true;
        }
        return org.apache.commons.lang.math.NumberUtils.isNumber((String)String.valueOf(value));
    }

    public static Number toNumber(Object value, Class resultClass) {
        Number original = NumberUtils.toNumber(value);
        if (resultClass == original.getClass()) {
            return original;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Byte");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resultClass == clazz) {
            return new Byte(original.byteValue());
        }
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resultClass == clazz2) {
            return new Short(original.shortValue());
        }
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resultClass == clazz3) {
            return new Integer(original.intValue());
        }
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resultClass == clazz4) {
            return new Long(original.longValue());
        }
        Class<?> clazz5 = class$2;
        if (clazz5 == null) {
            try {
                clazz5 = class$2 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resultClass == clazz5) {
            return new Float(original.floatValue());
        }
        Class<?> clazz6 = class$1;
        if (clazz6 == null) {
            try {
                clazz6 = class$1 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (resultClass == clazz6) {
            return new Double(original.doubleValue());
        }
        throw new UnsupportedOperationException("unsupported java.lang.Number sub class: " + resultClass.getName());
    }
}

