/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.lang;

import java.lang.reflect.Field;

public class FieldUtils {
    public static Object getValue(Object target, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        if (target instanceof Class) {
            return FieldUtils.getStaticValue((Class)target, fieldName);
        }
        return FieldUtils.getValue(target, target.getClass(), fieldName);
    }

    public static Object getStaticValue(Class clazz, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        return FieldUtils.getValue(null, clazz, fieldName);
    }

    public static Object getValue(Object target, Class clazz, String fieldName) throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException {
        Field field = FieldUtils.getField(clazz, fieldName);
        if (field == null) {
            throw new NoSuchFieldException(String.valueOf(clazz.getName()) + "#" + fieldName);
        }
        return field.get(target);
    }

    public static Field getField(Class clazz, String fieldName) {
        Field result = FieldUtils.getBySuperClass(clazz, fieldName);
        if (result != null) {
            return result;
        }
        result = FieldUtils.getByInterfacesOfClass(clazz, fieldName);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static Field getFieldImpl(Class clazz, String fieldName) {
        if (clazz == null) {
            return null;
        }
        Field[] fields = clazz.getDeclaredFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].getName().equals(fieldName)) {
                return fields[i];
            }
            ++i;
        }
        return null;
    }

    private static Field getBySuperClass(Class key, String fieldName) {
        Class current = key;
        while (current != null) {
            Field result = FieldUtils.getFieldImpl(current, fieldName);
            if (result != null) {
                return result;
            }
            current = current.getSuperclass();
        }
        return null;
    }

    private static Field getByInterfacesOfClass(Class key, String fieldName) {
        Class current = key;
        while (current != null) {
            Field result = FieldUtils.getByInterfaces(current.getInterfaces(), fieldName);
            if (result != null) {
                return result;
            }
            current = current.getSuperclass();
        }
        return null;
    }

    private static Field getByInterfaces(Class[] interfaces, String fieldName) {
        int i = 0;
        while (i < interfaces.length) {
            Field result = FieldUtils.getFieldImpl(interfaces[i], fieldName);
            if (result != null) {
                return result;
            }
            result = FieldUtils.getByInterfaces(interfaces[i].getInterfaces(), fieldName);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }
}

