/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.io.sf;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.asyrinx.brownie.core.io.sf.AbstractFileStreamFactory;

public class ClassResourceStreamFactory
extends AbstractFileStreamFactory {
    private final ClassLoader classLoader;

    public ClassResourceStreamFactory() {
        this(null);
    }

    public ClassResourceStreamFactory(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        this.classLoader = classLoader;
    }

    public InputStream newInput(Object key) throws IOException {
        return this.createNewInput(key);
    }

    protected final InputStream createNewInput(Object key) throws FileNotFoundException {
        String resourceName = this.keyToString(key);
        InputStream result = this.getClassLoader().getResourceAsStream(resourceName);
        if (result == null) {
            throw new FileNotFoundException(resourceName);
        }
        return result;
    }

    protected String keyFileToString(File key) {
        return key.getPath();
    }

    public OutputStream newOutput(Object key) throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getPath4Log(Object key) {
        return this.keyToString(key);
    }

    public String getCaption() {
        return "class resource";
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

