/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.chars.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.core.chars.CharactersDictionary;
import org.asyrinx.brownie.core.chars.CharactersExpressionParser;
import org.asyrinx.brownie.core.chars.impl.CompositeCharacters;
import org.asyrinx.brownie.core.chars.impl.StringCharacters;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.text.EscapedStringSplitter;

public class CharactersExpressionParserImpl
implements CharactersExpressionParser {
    private String stringCharacterSetBegin = "[[";
    private String stringCharacterSetEnd = "]]";
    private final CharactersDictionary dictionary;

    public CharactersExpressionParserImpl(CharactersDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public Characters[] parse(String expression) {
        List keys = this.parseToKeys(expression);
        ArrayList<Characters> result = new ArrayList<Characters>();
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (StringUtils.isEmpty((String)key)) continue;
            if (this.isStringCharacterSetKey(key)) {
                result.add(new StringCharacters(key, key));
                continue;
            }
            result.add(this.dictionary.get(key));
        }
        return result.toArray(new Characters[0]);
    }

    public Characters parseToComposite(String expression) {
        Characters[] characterSets = this.parse(expression);
        if (characterSets.length < 1) {
            return null;
        }
        if (characterSets.length == 1) {
            return characterSets[0];
        }
        return new CompositeCharacters(null, characterSets);
    }

    public Characters parseToComposite(String expression, String name) {
        Characters[] characterSets = this.parse(expression);
        return new CompositeCharacters(name, characterSets);
    }

    private boolean isStringCharacterSetKey(String key) {
        return key.startsWith(this.getStringCharacterSetBegin()) && key.endsWith(this.getStringCharacterSetEnd());
    }

    private List parseToKeys(String expression) {
        ArrayList result = new ArrayList();
        EscapedStringSplitter splitter = new EscapedStringSplitter(',', '\\');
        splitter.execute(expression, result);
        return result;
    }

    public String getStringCharacterSetBegin() {
        return this.stringCharacterSetBegin;
    }

    public void setStringCharacterSetBegin(String stringCharacterSetBegin) {
        this.stringCharacterSetBegin = stringCharacterSetBegin;
    }

    public String getStringCharacterSetEnd() {
        return this.stringCharacterSetEnd;
    }

    public void setStringCharacterSetEnd(String stringCharacterSetEnd) {
        this.stringCharacterSetEnd = stringCharacterSetEnd;
    }
}

