/*
 * Decompiled with CFR 0.152.
 */
package org.asyrinx.brownie.core.chars.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.asyrinx.brownie.core.chars.Characters;
import org.asyrinx.brownie.core.lang.StringUtils;
import org.asyrinx.brownie.core.lang.UnsupportedClassRuntimeException;

public abstract class AbstractCompositeCharacters
implements Characters {
    private final String name;

    public AbstractCompositeCharacters(String name) {
        this.name = name;
    }

    public AbstractCompositeCharacters(String name, Object components) {
        this(StringUtils.isEmpty((String)name) ? AbstractCompositeCharacters.buildName(AbstractCompositeCharacters.toIterator(components)) : name);
    }

    public String getName() {
        return this.name;
    }

    public static String buildName(Iterator componentsIterator) {
        StringBuffer result = new StringBuffer();
        Iterator i = componentsIterator;
        while (i.hasNext()) {
            Characters characterSet = (Characters)i.next();
            result.append(characterSet.getName());
            if (!i.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    protected static Iterator toIterator(Object components) {
        if (components.getClass().isArray()) {
            return new ArrayIterator(components);
        }
        if (components instanceof Collection) {
            return ((Collection)components).iterator();
        }
        throw new UnsupportedClassRuntimeException("components must be array or Collection");
    }

    protected static Iterator toIterator(List components) {
        return components.iterator();
    }

    protected abstract Iterator componentIterator();

    public boolean contains(char c) {
        Iterator i = this.componentIterator();
        while (i.hasNext()) {
            Characters characters = (Characters)i.next();
            if (!characters.contains(c)) continue;
            return true;
        }
        return false;
    }

    public String expandToString() {
        StringBuffer result = new StringBuffer();
        Iterator i = this.componentIterator();
        while (i.hasNext()) {
            Characters characters = (Characters)i.next();
            result.append(characters.expandToString());
        }
        return result.toString();
    }
}

