/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.util.xom;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import jp.sourceforge.jlogtest.util.xom.NodeEvaluator;
import nu.xom.Element;
import nu.xom.Text;

import org.junit.Test;

public class NodeEvaluatorTest {

	@Test
	public void isElementNamedメソッドはノードがElementでないときfalseを返す() throws Exception {
		final Text text = new Text("hoge");

		assertFalse(NodeEvaluator.isElementNamed(text, "hoge"));
	}

	@Test
	public void isElementNamedメソッドはノード名が一致しないときfalseを返す() throws Exception {
		final Element text = new Element("hoge");

		assertFalse(NodeEvaluator.isElementNamed(text, "foobar"));
	}

	@Test
	public void isElementNamedメソッドはノード名も一致する場合trueを返す() throws Exception {
		final Element text = new Element("hoge");

		assertTrue(NodeEvaluator.isElementNamed(text, "hoge"));
	}
}
