/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.util.xom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import jp.sourceforge.jlogtest.util.xom.NodeCreator;
import nu.xom.Attribute;

import org.junit.Test;

public class NodeCreatorTest {

	@Test
	public void getPreserveSpaceAttributeメソッドは毎回異なるインスタンスを返す() throws Exception {
		final Attribute attr1 = NodeCreator.getPreserveSpaceAttribute();
		final Attribute attr2 = NodeCreator.getPreserveSpaceAttribute();
		
		assertFalse(attr1 == attr2);
	}

	@Test
	public void getPreserveSpaceAttributeは正しい値を返す() throws Exception {
		final Attribute attr = NodeCreator.getPreserveSpaceAttribute();
		assertEquals("space", attr.getLocalName());
		assertEquals("preserve", attr.getValue());
		assertEquals("http://www.w3.org/XML/1998/namespace", attr.getNamespaceURI());
	}
}
