/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.util.xom;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import jp.sourceforge.jlogtest.util.xom.ChildSelector;
import nu.xom.Element;

import org.junit.Test;

public class ChildSelectorTest {

	@Test
	public void 指定した名前の子ノードが一つのときそれを取得可能() throws Exception {
		final ChildSelector selector = new ChildSelector(getXmlWith1child());
		
		assertTrue(selector.isUnique("child"));
		
		// ユニークであるノードを取得
		final Element child = selector.getUniqueElement("child");
		assertEquals("sample text", child.getValue());
	}
	
	@Test
	public void 指定した名前の子ノードが存在しないとき例外をスロー() throws Exception {
		final ChildSelector selector = new ChildSelector(getXmlWithoutChild());
		
		assertFalse(selector.isUnique("child"));
		
		// 存在しないにもかかわらず取得を試みる
		try {
			selector.getUniqueElement("child");
			fail();
		} catch (IllegalArgumentException e) {
			// 存在しないものを取得しようとしたので例外をスロー
		}
	}

	@Test
	public void 指定した名前の子ノードが2つ以上存在するとき例外をスロー() throws Exception {
		final ChildSelector selector = new ChildSelector(getXmlWith2Children());
		
		assertFalse(selector.isUnique("child"));
		
		// 2つ存在するにもかかわらず取得を試みる
		try {
			selector.getUniqueElement("child");
			fail();
		} catch (IllegalArgumentException e) {
			// ユニークでないものを取得しようとしたので例外をスロー
		}
	}

	private Element getXmlWith2Children() {
		final Element root = new Element("root");
		root.appendChild(getChild("child", "sample text"));
		root.appendChild(getChild("child", "sample text"));
		return root;
	}

	private Element getXmlWithoutChild() {
		final Element root = new Element("root");
		return root;
	}

	private Element getXmlWith1child() {
		final Element root = new Element("root");
		root.appendChild(getChild("child", "sample text"));
		return root;
	}

	private Element getChild(final String name, final String value) {
		final Element child = new Element(name);
		child.appendChild(value);
		return child;
	}
}

