/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.util.xom;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.io.File;
import java.util.Iterator;
import java.util.NoSuchElementException;

import jp.sourceforge.jlogtest.util.xom.ChildNodeIterator;

import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;

import org.junit.Test;

public class ChildNodeIteratorTest {

	private static final String PATH_TO_RESOURCE_DIR = "src/test/resources/ChildNodeIteratorTest";

	@Test
	public void XMLを正しくイテレートする() throws Exception {
		final Iterator<Node> iter = getIterator("test1.xml");
		
		// 1つめのノードはText（空白文字）
		assertTrue(iter.next() instanceof Text);
		// 2つめのノードはElementノード（child要素）
		assertTrue(iter.next() instanceof Element);
		// 3つめのノードはText（空白文字）
		assertTrue(iter.next() instanceof Text);
		try {
			iter.next();
			fail();
		} catch (NoSuchElementException e) {
			// 4つめの要素はもうないので
		}
	}

	@Test
	public void hasNextメソッドが正しく動作する() throws Exception {
		final Iterator<Node> iter = getIterator("test1.xml");
		
		assertTrue(iter.hasNext());
		iter.next(); // 1つめのノード（空白文字）を取得
		assertTrue(iter.hasNext());
		iter.next(); // 2つめのノード（child要素）を取得
		iter.next(); // 3つめのノード（空白文字）を取得
		assertFalse(iter.hasNext()); // もう子ノードは存在しない
	}

	@Test
	public void removeメソッドは常に例外をスローする() throws Exception {
		final Iterator<Node> iter = getIterator("test1.xml");
		
		try {
			iter.remove();
			fail();
		} catch (UnsupportedOperationException e) {
		}
		iter.next();
		iter.next();
		iter.next();
		try {
			iter.remove();
			fail();
		} catch (UnsupportedOperationException e) {
		}
	}

	private static Iterator<Node> getIterator(final String fileName) throws Exception {
		final Element root = TestUtil.getXmlElement(new File(PATH_TO_RESOURCE_DIR
				+ "/" + fileName));
		final ChildNodeIterator iterable = new ChildNodeIterator(root);
		return iterable.iterator();
	}
}
