/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.util.java;

import static org.junit.Assert.assertEquals;
import jp.sourceforge.jlogtest.util.java.StackInspector;

import org.junit.Test;

public class StackInspectorTest {

	@Test
	public void Callerのクラス名を取得できる() throws Exception {
		assertEquals(StackInspectorTest.class.getName(), StackInspector.getCallerClass(1));
	}

	@Test
	public void CallerのCallerのクラス名を取得できる() throws Exception {
		assertEquals(StackInspectorTest.class.getName(), getCallerClass());
	}

	private static String getCallerClass() {
		return StackInspector.getCallerClass(2);
	}
}

