/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.annotations;

import static org.junit.Assert.assertTrue;

import java.io.IOException;

import jp.sourceforge.jlogtest.DIContainer;
import jp.sourceforge.jlogtest.IOperationFactory;
import jp.sourceforge.jlogtest.IOperationMode;
import jp.sourceforge.jlogtest.JclLogLevel;
import jp.sourceforge.jlogtest.TargetSequence;
import jp.sourceforge.jlogtest.junit.JLogTestRunner;

import nu.xom.ParsingException;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;

public class JLogTestWithAnnotations5Test {
	
	private boolean recordModeCalled;
	
	@Before
	public void setUp() throws Exception {
		DIContainer.setOperationMode(new MockOperationFactory());
		
		recordModeCalled = false;
	}
	
	@After
	public void tearDown() throws Exception {
		DIContainer.reset();
	}

	public class MockOperationFactory implements IOperationFactory {
		
		public IOperationMode createPlayMode(
				final String pathToDir, final Class<?> clazz, final String method) {
			throw new AssertionError();
		}
		
		public IOperationMode createRecordMode(
				final String pathToDir, final Class<?> clazz, final String method) {
			
			recordModeCalled = true;

			return new MockRecordMode();
		}
	}

	public static class MockRecordMode implements IOperationMode {

		public void start() throws ParsingException, IOException {
		}

		public void stop() throws IOException {
		}

		public void addTarget(final TargetSequence sequence) {
		}
	}

	@Test
	public void 記録モードで実行されることを確認()
			throws Exception {
		final JUnitCore runner = new JUnitCore();
		runner.run(TestToBeTested.class);
		
		assertTrue(recordModeCalled);
	}

	@RunWith(JLogTestRunner.class)
	@Record
	public static class TestToBeTested {
		
		@Before
		public void setUp() throws Exception {
			JLogTestRunner.setLogDirectory("path/to/dir");
		}

		@TargetLogs(
			@Sequence(
				jcl = @JclLog(clazz = TestToBeTested.class, level = JclLogLevel.INFO)
			)
		)
		@Test
		public void testHoge() throws Exception {
		}
	}
}
