/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.annotations;

import jp.sourceforge.jlogtest.DIContainer;
import jp.sourceforge.jlogtest.IOperationFactory;
import jp.sourceforge.jlogtest.IOperationMode;
import jp.sourceforge.jlogtest.junit.JLogTestRunner;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;

public class JLogTestWithAnnotations4Test {
	
	@Before
	public void setUp() throws Exception {
		DIContainer.setOperationMode(new MockOperationFactory());
	}

	@After
	public void tearDown() throws Exception {
		DIContainer.reset();
	}

	public static class MockOperationFactory implements IOperationFactory {
		
		public MockOperationFactory() {
		}
		
		public IOperationMode createPlayMode(
				final String pathToDir, final Class<?> clazz, final String method) {
			throw new AssertionError();
		}
		
		public IOperationMode createRecordMode(
				final String pathToDir, final Class<?> clazz, final String method) {
			throw new AssertionError();
		}
	}

	@Test
	public void 取得するログが存在しないテストは通常のJUnitのテストと同じように実行する()
			throws Exception {
		
		final JUnitCore runner = new JUnitCore();
		runner.run(TestToBeTested.class);
	}

	@RunWith(JLogTestRunner.class)
	public static class TestToBeTested {

		@Test
		public void testHoge() throws Exception {
		}
	}
}
