/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.annotations;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.io.IOException;

import jp.sourceforge.jlogtest.IOperationMode;
import jp.sourceforge.jlogtest.TargetSequence;

import nu.xom.ParsingException;

public class IOperationModeTester implements IOperationMode {

	public static boolean startCalled;
	public static boolean stopCalled;
	public static boolean addTargetCalled;
	
	public IOperationModeTester() {
		startCalled = stopCalled = addTargetCalled =  false;
	}

	public void start() throws ParsingException, IOException {
		assertFalse(startCalled);
		
		assertTrue(addTargetCalled);
		
		startCalled = true;
	}

	public void stop() throws IOException {
		assertFalse(stopCalled);
		
		assertTrue(startCalled);
		
		stopCalled = true;
	}

	public void addTarget(final TargetSequence sequence) {
		// このメソッド自体は何度も呼び出される可能性がある
		
		assertFalse(startCalled);
		assertFalse(stopCalled);
		
		addTargetCalled = true;
	}

	public static void verify() {
		assertTrue(startCalled);
		assertTrue(stopCalled);
		assertTrue(addTargetCalled);
	}
}
