/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.annotations;

import jp.sourceforge.jlogtest.JclLogLevel;
import jp.sourceforge.jlogtest.util.java.HashGen;

class AddTargetArg {

	private final Class<?> clazz;
	private final JclLogLevel level;
	
	public AddTargetArg(final Class<?> clazz, final JclLogLevel level) {
		this.clazz = clazz;
		this.level = level;
	}

	@Override
	public boolean equals(final Object obj) {
		return
				clazz.equals(((AddTargetArg)obj).clazz) &&
				level.equals(((AddTargetArg)obj).level);
	}
	
	@Override
	public int hashCode() {
		return HashGen.gen(clazz, level);
	}
}


