/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.jlogtest.JclLogType;

public class TestUtil {

	private TestUtil() {
	}

	public static String getResourcePath(final Class<?> clazz) {
		return "src/test/resources/" + clazz.getSimpleName();
	}

	public static String getTempDirPath() {
		return "testDir";
	}

	public static void removeRecursively(final File file) {
		if (file.isDirectory()) {
			for (final File each : file.listFiles())
				removeRecursively(each);
		}
		file.delete();
	}

	public static Set<String> getLogSet(final String... logs) {
		final Set<String> logSet = new HashSet<String>();
		Collections.addAll(logSet, logs);
		return logSet;
	}

	public static Set<JclLogType> getJclLogSet(final JclLogType... logs) {
		final Set<JclLogType> logSet = new HashSet<JclLogType>();
		Collections.addAll(logSet, logs);
		return logSet;
	}
}
