/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import static java.lang.String.format;

public class MyAssertion {

	private MyAssertion() {
	}

	public static void assertFileEquals(final File expected, final File actual)
			throws IOException {
		final BufferedReader eStream = getBufferedReader(expected);
		final BufferedReader aStream = getBufferedReader(actual);

		int line = 0;
		String eStr;
		while ((eStr = eStream.readLine()) != null) {
			line++;
			final String aStr = aStream.readLine();
			if (!eStr.equals(aStr)) {
				throwAssertionError(eStr, (aStr == null) ? "<null>" : aStr, line);
			}
		}
		String aStr;
		if ((aStr = aStream.readLine()) != null) {
			throwAssertionError("<null>", aStr, line + 1);
		}
	}
	
	private static BufferedReader getBufferedReader(final File file) throws FileNotFoundException {
		try {
			return new BufferedReader(
					new InputStreamReader(
				    new FileInputStream(file), "UTF-8"));
		} catch (UnsupportedEncodingException e) {
			throw new Error("System Error!!", e);
		}
	}
	
	private static void throwAssertionError(final String expected, final String actual, final int line) {
		throw new AssertionError(format(
				"\nexpected : [%s],\nbut actual : [%s],\nin line %d", expected,
				actual, line));
	}
}
