/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertSame;
import jp.sourceforge.jlogtest.ILog;
import jp.sourceforge.jlogtest.JclLogInfo;
import jp.sourceforge.jlogtest.JclLogLevel;
import jp.sourceforge.jlogtest.LogVerificationException;

import org.junit.Test;

public class LogVerificationExceptionTest {

	@Test
	public void 予期したログと実際のログを取得可能() throws Exception {
		final ILog expected = new JclLogInfo("expected log", "test.ClassName", JclLogLevel.INFO);
		final ILog actual = new JclLogInfo("actual log", "test.ClassName", JclLogLevel.INFO);
		
		final LogVerificationException e = new LogVerificationException(expected, actual);
		assertSame(expected, e.getExpected());
		assertSame(actual, e.getActual());
	}

	@Test
	public void ログの比較をメッセージとして取得可能1() throws Exception {
		final ILog expected = new JclLogInfo("expected log", "test.ClassName", JclLogLevel.INFO);
		final ILog actual = new JclLogInfo("actual log", "test.ClassName", JclLogLevel.INFO);
		
		final LogVerificationException e = new LogVerificationException(expected, actual);
		assertEquals(
				"[expected]\nclass : test.ClassName\nlevel : INFO\ntext : 'expected log'\n\n" +
				"[actual]\nclass : test.ClassName\nlevel : INFO\ntext : 'actual log'\n",
				e.getMessage());
	}

	@Test
	public void ログの比較をメッセージとして取得可能2() throws Exception {
		final ILog expected = new JclLogInfo("expected log", "test.ClassName", JclLogLevel.INFO);
		
		final LogVerificationException e = new LogVerificationException(expected, null);
		assertEquals(
				"[expected]\nclass : test.ClassName\nlevel : INFO\ntext : 'expected log'\n\n" +
				"[actual]\nNo Log\n",
				e.getMessage());
	}

	@Test
	public void ログの比較をメッセージとして取得可能3() throws Exception {
		final ILog actual = new JclLogInfo("actual log", "test.ClassName", JclLogLevel.INFO);
		
		final LogVerificationException e = new LogVerificationException(null, actual);
		assertEquals(
				"[expected]\nNo Log\n\n" +
				"[actual]\nclass : test.ClassName\nlevel : INFO\ntext : 'actual log'\n",
				e.getMessage());
	}
}
