/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import static org.junit.Assert.assertTrue;
import jp.sourceforge.jlogtest.ILoggable;
import jp.sourceforge.jlogtest.JclLogInfo;
import jp.sourceforge.jlogtest.JclLogLevel;
import jp.sourceforge.jlogtest.JclReceiver;

import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;

public class JclReceiverTest {
	
	private ILoggable loggableMock;
	
	@Before
	public void setMock() throws Exception {
		loggableMock = EasyMock.createMock(ILoggable.class);
	}

	@Before
	public void initializeClass() throws Exception {
		JclReceiver.setLogger(null);
	}

	@Test
	public void 全てのレベルが有効になっている() throws Exception {
		final JclReceiver receiver = new JclReceiver("ClassName");
		
		assertTrue(receiver.isFatalEnabled());
		assertTrue(receiver.isErrorEnabled());
		assertTrue(receiver.isWarnEnabled());
		assertTrue(receiver.isInfoEnabled());
		assertTrue(receiver.isDebugEnabled());
		assertTrue(receiver.isTraceEnabled());
	}

	@Test
	public void どのレベルでログを送信しても正しく受信できる() throws Exception {
		JclReceiver.setLogger(loggableMock);
		final JclReceiver receiver = new JclReceiver("ClassName");
		
		// Mock Objectに期待するアクセスを記録
		loggableMock.addLog(new JclLogInfo("fatal log", "ClassName", JclLogLevel.FATAL));
		loggableMock.addLog(new JclLogInfo("error log", "ClassName", JclLogLevel.ERROR));
		loggableMock.addLog(new JclLogInfo("warn log", "ClassName", JclLogLevel.WARN));
		loggableMock.addLog(new JclLogInfo("info log", "ClassName",  JclLogLevel.INFO));
		loggableMock.addLog(new JclLogInfo("debug log", "ClassName", JclLogLevel.DEBUG));
		loggableMock.addLog(new JclLogInfo("trace log", "ClassName", JclLogLevel.TRACE));
		
		EasyMock.replay(loggableMock);
		
		receiver.fatal("fatal log");
		receiver.error("error log");
		receiver.warn("warn log");
		receiver.info("info log");
		receiver.debug("debug log");
		receiver.trace("trace log");
		
		EasyMock.verify(loggableMock);
	}
}

