/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.util.xom;

import java.util.Iterator;

import nu.xom.Element;
import nu.xom.ParentNode;

public class ChildSelector {
	
	private final ParentNode node;

	public ChildSelector(final ParentNode node) {
		this.node = node;
	}
	
	public boolean isUnique(final String name) {
		final Iterator<Element> children =
			new SpecificChildElementIterator(node, name).iterator();
		if (!children.hasNext())
			return false;
		children.next();
		if (children.hasNext())
			return false;
		return true;
	}

	public Element getUniqueElement(final String name) {
		final Iterator<Element> children =
			new SpecificChildElementIterator(node, name).iterator();
		if (!children.hasNext())
			throw new IllegalArgumentException();
		final Element toReturn = children.next();
		if (children.hasNext())
			throw new IllegalArgumentException();
		return toReturn;
	}
}
