/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.util.xom;

import java.util.Iterator;
import java.util.NoSuchElementException;

import nu.xom.Node;
import nu.xom.ParentNode;

public class ChildNodeIterator implements Iterable<Node> {
	
	private final ParentNode parentNode;
	
	public ChildNodeIterator(final ParentNode parentNode) {
		this.parentNode = parentNode;
	}

	public Iterator<Node> iterator() {
		return new NodeIterator(parentNode);
	}

	private static class NodeIterator implements Iterator<Node> {
		
		private int count;
		
		private final ParentNode parentNode;
		
		private NodeIterator(final ParentNode parentNode) {
			this.parentNode = parentNode;
			count = 0;
		}
		
		private boolean invariant() {
			return 0 <= count && count <= parentNode.getChildCount(); 
		}

		public boolean hasNext() {
			assert invariant();
			
			return count != parentNode.getChildCount();
		}

		public Node next() {
			assert invariant();
			
			if (count == parentNode.getChildCount()) {
				throw new NoSuchElementException();
			}
			return parentNode.getChild(count++);
		}

		public void remove() {
			throw new UnsupportedOperationException();
		}
	}
}
