/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest.junit;

import org.junit.internal.runners.InitializationError;
import org.junit.internal.runners.TestClassRunner;

public class JLogTestRunner extends TestClassRunner {
	
	private static final LogDirectoryPath logDirectory = new LogDirectoryPath();

	public JLogTestRunner(final Class<?> clazz) throws InitializationError {
		super(clazz, new JLogTestClassMethodsRunner(clazz, logDirectory));
	}

	public static void setLogDirectory(final String path) {
		logDirectory.setPath(path);
	}
	
	public static class LogDirectoryPath implements ILogDirectoryPath {
		
		private static String logDirectory;
		
		public void setPath(final String path) {
			logDirectory = path;
		}

		public String getPath() {
			return logDirectory;
		}
	}
}
