/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

import static java.lang.String.format;

import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;
import nu.xom.Serializer;

public class XmlFileManipulator {

	private final String pathToBase;

	public XmlFileManipulator(final String pathToBase) {
		this.pathToBase = pathToBase;
	}

	public void output(final Element element, final String clazz,
			final String method) throws IOException {

		final Document doc = new Document(element);
		final OutputStream output = getOutputStream(clazz, method);
		try {
			final Serializer serializer = new Serializer(output, "UTF-8");
			serializer.setIndent(4);
			serializer.setMaxLength(100);
			serializer.write(doc);
		} catch (UnsupportedEncodingException e) {
			assert false;
			throw new Error("System error!!", e);
		} finally {
			output.close();
		}
	}

	public Document input(final String clazz, final String method)
			throws ParsingException, IOException {
		return new Builder().build(getFile(pathToBase, clazz, method));
	}

	private FileOutputStream getOutputStream(final String clazz,
			final String method) throws FileNotFoundException {

		final File fileToSaveXml = getFile(pathToBase, clazz, method);
		{
			final File dir = fileToSaveXml.getParentFile();
			dir.mkdirs();
		}
		return new FileOutputStream(fileToSaveXml);
	}

	private static File getFile(final String base, final String clazz,
			final String method) {
		return new File(format("%s/%s#%s.xml", base,
				qualifiedClassNameToPath(clazz), method));
	}

	private static String qualifiedClassNameToPath(final String className) {
		return className.replace('.', '/');
	}
}
