/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.collections.CollectionUtils;

public class VerifierContainer implements ILoggable {
	
	private final Map<String, Verifier> verifiers;
	private final Map<String, ILog[]> recordedLogs;

	public VerifierContainer(final Map<String, ILog[]> recordedLogs) {
		verifiers = new HashMap<String, Verifier>();
		this.recordedLogs = recordedLogs;
	}
	
	public void addSequence(final TargetSequence sequence) {
		final String name = sequence.getName();
		verifiers.put(name,
				new Verifier.FilterableVerifier(recordedLogs.get(name), sequence));
	}
	
	@SuppressWarnings("unchecked")
	public void verifySequence() {
		final Collection<String> seqPlaying = verifiers.keySet(); 
		final Collection<String> seqRecorded = recordedLogs.keySet();
		
		final Collection<String> added =
			CollectionUtils.subtract(seqPlaying, seqRecorded);
		final Collection<String> removed =
			CollectionUtils.subtract(seqRecorded, seqPlaying);

		if (!added.isEmpty() || !removed.isEmpty())
			throw new SequencesNotMatchException(added, removed);
	}
	
	public void addLog(final ILog log) {
		for (final Verifier verifier : verifiers.values())
			verifier.addLog(log);
	}

	public void finish() {
		for (final Verifier verifier : verifiers.values())
			verifier.finish();
	}
}
