/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

public class Verifier implements ILoggable {
	
	private final ILog[] expectedList;
	private int count;
	
	public Verifier(final ILog[] expectedList) {
		this.expectedList = expectedList;
		count = 0;
	}

	public void addLog(final ILog actual) {
		assert invariant();
		
		if (expectedList.length == count)
			throwVerificationException(null, actual);

		final ILog expected = expectedList[count++];
		
		if (!expected.equals(actual))
			throwVerificationException(expected, actual);
	}

	public void finish() {
		assert invariant();
		
		if (count != expectedList.length)
			throwVerificationException(expectedList[count], null);
	}

	private boolean invariant() {
		return 0 <= count && count <= expectedList.length;
	}

	private static void throwVerificationException(
			final ILog expected, final ILog actual) {
		throw new LogVerificationException(expected, actual);
	}

	public static class FilterableVerifier extends Verifier {
		
		private final TargetSequence filter;

		public FilterableVerifier(final ILog[] expectedList, final TargetSequence filter) {
			super(expectedList);
			
			this.filter = filter;
		}

		@Override
		public void addLog(final ILog log) {
			if (filter.contains(log))
				super.addLog(log);
		}
	}
}
