/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.util.HashSet;
import java.util.Set;

import jp.sourceforge.jlogtest.util.java.HashGen;

public class TargetSequence {

	private final String name;
	private final Set<JclLogType> jcl;
	private final Set<String> log;
	
	public TargetSequence(
			final String name, final Set<JclLogType> jcl, final Set<String> log) {
		if (name == null)
			throw new NullPointerException();
		this.name = name;
		this.jcl = new HashSet<JclLogType>();
		this.jcl.addAll(jcl);
		this.log = new HashSet<String>();
		this.log.addAll(log);
	}
	
	public boolean hasJclLog() {
		return 0 < jcl.size();
	}
	
	public String getName() {
		return name;
	}

	public boolean contains(final ILog log) {
		if (log instanceof JclLogInfo) {
			final JclLogInfo logInfo = (JclLogInfo)log;
			// TODO リファクタリング
			return jcl.contains(
					new JclLogType(logInfo.getClassName(), logInfo.getJclLogLevel()));
		}
		if (log instanceof LogInfo) {
			final LogInfo logInfo = (LogInfo)log;
			return this.log.contains(logInfo.getName());
		}
		return false;
	}

	@Override
	public boolean equals(final Object obj) {
		if (!(obj instanceof TargetSequence))
			return false;
		final TargetSequence obj2 = (TargetSequence)obj;
		return jcl.equals(obj2.jcl) && log.equals(obj2.log) && isEqual(name, obj2.name);
	}
	
	private static boolean isEqual(final Object obj1, final Object obj2) {
		// (null instanceof String) 等はfalseになる（Javaの仕様）
		return obj1 == null ? obj2 == null : obj1.equals(obj2);
	}

	@Override
	public int hashCode() {
		return HashGen.gen(name, jcl, log);
	}
}
