/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SequencesNotMatchException extends RuntimeException {

	private static final long serialVersionUID = 6640723844853524823L;
	
	private final Set<String> added;
	private final Set<String> removed;
	
	public SequencesNotMatchException(
			final Collection<String> added, final Collection<String> removed) {

		this.added = new HashSet<String>(added);
		this.removed = new HashSet<String>(removed);
	}

	public Set<String> getAddedSequences() {
		return new HashSet<String>(added);
	}

	public Set<String> getRemovedSequences() {
		return new HashSet<String>(removed);
	}
}
