/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.io.IOException;

public class RecordMode implements IOperationMode {
	
	private final LogTestCase logTestCase;
	private final XmlFileManipulator readerWriter;
	private final String testCaseClass;
	private final String testCaseMethod;
	private final IMessageOutputter messageOutputter;
	private boolean enableJcl;
	
	public RecordMode(final String pathToDir, final Class<?> clazz, final String method, final IMessageOutputter messageOutputter) {
		readerWriter = new XmlFileManipulator(pathToDir);
		testCaseClass = clazz.getName();
		testCaseMethod = method;
		this.messageOutputter = messageOutputter; 
		LoggerFactory.reset();
		logTestCase = new LogTestCase(testCaseClass, testCaseMethod);
		enableJcl = false;
	}

	public void start() {
		// JCLが必要でない場合には、JCLのクラスがロードされないようにする
		//（この機能のテストコードはナシ）
		if (enableJcl)
			JclReceiver.setLogger(logTestCase);
		LoggerFactory.setLogger(logTestCase);
	}

	public void stop() throws IOException {
		readerWriter.output(logTestCase.asXml(),
				logTestCase.getTestCaseClass(), logTestCase.getTestCaseMethod());
		notifyRecorded();
	}

	public void addTarget(final TargetSequence sequence) {
		enableJcl = enableJcl || sequence.hasJclLog();
		logTestCase.addSequence(sequence);
	}
	
	private void notifyRecorded() {
		final String message =
				"class : " + testCaseClass + "\n" +
				"method : " + testCaseMethod + "\n" +
				"のテストを記録しました。\n\n";
		messageOutputter.output(message);
	}
}
