/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.io.IOException;

import nu.xom.ParsingException;

public class PlayMode implements IOperationMode {

	private final XmlFileManipulator readerWriter;
	private final String testCaseClass;
	private final String testCaseMethod;
	private final VerifierContainer verifier;
	private boolean enableJcl;

	public PlayMode(final String pathToDir, final Class<?> clazz,
			final String method) throws ParsingException, IOException {
		readerWriter = new XmlFileManipulator(pathToDir);
		testCaseClass = clazz.getName();
		testCaseMethod = method;
		LoggerFactory.reset();
		final LogTestCase logTestCase = new LogTestCase(readerWriter.input(testCaseClass,
				testCaseMethod).getRootElement());
		verifier = new VerifierContainer(logTestCase.getLogs());
		enableJcl = false;
	}

	public void start() throws ParsingException, IOException {
		verifier.verifySequence();
		if (enableJcl)
			JclReceiver.setLogger(verifier);
		LoggerFactory.setLogger(verifier);
	}

	public void stop() {
		verifier.finish();
	}

	public void addTarget(final TargetSequence sequence) {
		enableJcl = enableJcl || sequence.hasJclLog();
		verifier.addSequence(sequence);
	}
}
