/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

import java.io.IOException;

import nu.xom.ParsingException;

public class OperationFactory implements IOperationFactory {

	public IOperationMode createPlayMode(final String pathToDir,
			final Class<?> clazz, final String method) throws ParsingException,
			IOException {
		return new PlayMode(pathToDir, clazz, method);
	}

	public IOperationMode createRecordMode(final String pathToDir,
			final Class<?> clazz, final String method) {
		return new RecordMode(pathToDir, clazz, method,
				new StandardMessageOutputter());
	}
}
