/* Copyright 2006 Harai Akihiro.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *     http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package jp.sourceforge.jlogtest;

public class LoggerFactory {
	
	private static ILoggable logger_ = null;
	
	private LoggerFactory() {
	}
	
	static void setLogger(final ILoggable logger) {
		logger_ = logger; 
	}

	static void reset() {
		logger_ = null;
	}

	public static Logger getLogger(final String name) {
		return new Logger(name, new PipeLogger());
	}
	
	public static class PipeLogger {
		public void addLog(final String log, final String name) {
			logger_.addLog(new LogInfo(log, name));
		}
	}
}
